<?php
namespace services;
require_once __DIR__.'/../autoloader.php';
require_once __DIR__.'/../autoloader.php';

use jpi\lib\Transaction as MyTransaction;
use jpi\lib\Formatage as MyFormatage;

if ( isset($_GET['file']) &&  isset($_GET['user'])) {
	$udl = $_GET['file'];
	$uid = $_GET['user'];
	$version = null;
	if ( isset($_GET['version']) ) 
	{
		$version = $_GET['version'];
		$query = sprintf("SELECT F.udl, F.extension, F.repertoire, %s, U.uid 
				FROM ged_ligne L, ged_fichier F, ged_utilisateur U 
				WHERE F.id_ligne = L.id AND L.id_user = U.id AND L.udl = %s AND U.uid = %s %s
				GROUP BY L.udl", 
				'V.version',
				MyFormatage::GetSQLValueString($udl, "text"),
				MyFormatage::GetSQLValueString($uid, "text"),
				"AND V.version = $version"
			);
	}
	else
	{
		$query = sprintf("SELECT L.udl, L.extension, L.repertoire, max(F.version) as version, U.uid 
				FROM jpi_ligne L, jpi_fichier F, jpi_user U 
				WHERE F.id_ligne = L.id AND L.id_user = U.id AND L.udl = %s AND U.uid = %s
				GROUP BY L.udl", 
				MyFormatage::GetSQLValueString($udl, "text"),
				MyFormatage::GetSQLValueString($uid, "text")
			);
	}
	$myTransaction = new MyTransaction();
	$myTransaction->addQuery($query);
	$myTransaction->execute();
	if ($myTransaction->asResult())
	{
		$row = $myTransaction->getNextRow();
	
		$fichier = "../".$row['repertoire'].$row['udl']."_".$row['version'].".".$row['extension'];
		
		// Création des headers, pour indiquer au navigateur qu'il s'agit d'un fichier à télécharger
		header('Content-Transfer-Encoding: binary'); //Transfert en binaire (fichier)
		header('Content-Disposition: attachment; filename="'.basename($fichier).'"'); //Nom du fichier
		header('Content-Type: application/force-download');
		header('Content-Length: ' . filesize($fichier)); //Taille du fichier
		
		//Envoi du fichier dont le chemin est passé en paramètre
		readfile($fichier);
	}
}
