<?php
namespace jpi\services;
require_once __DIR__.'/../autoloader.php';

use jpi\lib\Formatage as MyFormatage;
use jpi\lib\Transaction as MyTransaction;

if ( isset($_GET['file']) &&  isset($_GET['user'])) {
	$udl     = $_GET['file'];
	$uid     = $_GET['user'];
	$version = $_GET['version'];
	$query = sprintf("SELECT F.commentaire 
			FROM jpi_ligne L, jpi_fichier F, jpi_user U 
			WHERE F.id_ligne = L.id AND L.id_user = U.id 
			AND U.uid = %s AND L.udl = %s AND F.version = %s", 
			MyFormatage::GetSQLValueString($uid, "text"),
			MyFormatage::GetSQLValueString($udl, "text"),
			MyFormatage::GetSQLValueString($version, "int")
		);
	$myTransaction = new MyTransaction();
	$myTransaction->addQuery($query);
	$myTransaction->execute();
	if ($myTransaction->asResult())
	{
		// Création des headers, pour indiquer au navigateur qu'il s'agit d'un fichier à télécharger
		header('Content-Transfer-Encoding: text/plain'); 
		header('Content-Type: application/force-download');
		header('Content-Disposition: attachment; filename="'.$uid.'-'.$version.'-commentaire.json"'); //Nom du fichier
		
		//Envoi dans le flux
		$row = $myTransaction->getNextRow();
		echo json_encode($row);
	}
}
