<?php
	use lib\DisplayEntity;
	use lib\security\Security;
	use entities\Programme_Synthese;
	
	$programme = $Model['entity'];
	$synthese = $programme->synthese;
	if ( $synthese == null ) $synthese = new Programme_Synthese();
	$action = "update";
?>

<H1>Synthese de la randonnée</H1>
	
<ul class="Boutons">
	<?= DisplayEntity::displayBouton('retour','Retour') ?>
</ul>

<FORM id="formProgSynthese" name="formProgSynthese" class="form" action="_Programme_synthese" method="POST" autocomplete="off" enctype="multipart/form-data">

	<DIV class="table form">

		<H2>Lieu de la randonnée</H2>

		<DIV>
			<LABEL>Type de randonnée : </LABEL>
			<SPAN><?= $programme->id_randonnee->id_typerando ?></SPAN>
		</DIV>
		<DIV>
			<LABEL>Département : </LABEL>
			<SPAN><?= $programme->id_randonnee->departement ?></SPAN>
		</DIV>
		<DIV>
			<LABEL>Commune : </LABEL>
			<SPAN><?= $programme->id_randonnee->commune ?></SPAN>
		</DIV>
		<DIV>
			<LABEL>Lieu : </LABEL>
			<SPAN><?= $programme->id_randonnee->lieu ?></SPAN>
		</DIV>

		<H2>
			Fichiers
			<UL class="tinyBoutons">
				<LI class="ajaxAdd add" data-url="_Fichier_add" data-idcible="fichiers" >Ajouter</LI>
			</UL>
		</H2>
		<?= $programme->getAttribut('fichiers')->displayCell($programme->id,true,true,'views/fichier/displayElmt.php') ?>
		
		<H2>Synthèse</H2>
		<?= $programme->getAttribut('syntheses')->displayCell($programme->id,true,true,'views/synthese/displaySyntheseProgramme.php',true) ?>

	</DIV>

	<input type="hidden" name="validForm" value="formProgSynthese" />
	<input type="hidden" name="id" value="<?= $programme->id ?>" />
		
	<ul class="Boutons" data-formname="formProgSynthese">
		<li class="submit">Valider</li>
		<li class="cancel">Annuler</li>
	</ul>

	<input type="submit" value="submit" />
</FORM>


