<?php
	use entities\Membre;
	use entities\Randonnee;
	use entities\Parcour;
	use entities\Programme;
	use entities\Cheque;
	
	$annee = $Model['annee'];
	
	$adherents          = Membre::selectList("id_etat != 7");
	$adherentsAnimateur = Membre::selectList("id_etat = 1 AND id IN (SELECT id_membre FROM gari_role_membre WHERE id_role = 2)");
	$adherentsActif     = Membre::selectList("id_etat = 1 AND actif = 1");
	$lieux              = Randonnee::selectList();
	$parcours           = Parcour::selectList();
	$Programmes         = Programme::selectList();
	$randonnees         = Programme::selectList("valide = 1 AND YEAR(datedepart) = ".$annee);
	$cheques            = Cheque::selectList("YEAR(dateCheque) = ".$annee);
	$totalSommeCheques  = 0;
	$nbparticipants     = 0;
	$nbkm               = 0;
	$nbdeniv            = 0;
	foreach ( $randonnees as $rando ) {
		$nbparticipants += count($rando->participants);
		foreach ( $rando->parcours as $parc ) {
			$parc = $parc->id_parcour;
			$nbkm += $parc->longueur;
			$nbdeniv += $parc->deniveleup;
		}
	}
	foreach ( $cheques as $cheq ) {
		$totalSommeCheques += $cheq->montantCheque;
	}
	
	function getLstElements($obj,$filtre,$annee)
	{
		$annee = 2014;
		$str = '';
		for ( $cpt = 0 ; $cpt < 12 ; $cpt++ )
		{
			$mois = ($cpt + 8)%12+1;
			if ( $mois == 1 ) $annee = $annee +1;
			$lst = $obj::selectList($filtre." AND YEAR(datedepart) = ".$annee." AND MONTH(datedepart) = ".$mois);
			if ( $str != '' ) $str .= ',';
			switch ( $mois ) {
				case 1  : $mois = 'Jan.';break;
				case 2  : $mois = 'Fev.';break;
				case 3  : $mois = 'Mar.';break;
				case 4  : $mois = 'Avr.';break;
				case 5  : $mois = 'Mai.';break;
				case 6  : $mois = 'Jui.';break;
				case 7  : $mois = 'Jul.';break;
				case 8  : $mois = 'Aou.';break;
				case 9  : $mois = 'Sep.';break;
				case 10 : $mois = 'Oct.';break;
				case 11 : $mois = 'Nov.';break;
				case 12 : $mois = 'Dec.';break;
			}
			$str .= '["'.$mois.'",'.count($lst).']';
		}
		return $str;
	}
?>

<STYLE type="text/css">
<!--
	TABLE {
		width:18cm;
	}
	TABLE TH {
		width:60%;
		background-color: #333;
		text-align: right;
	}
	TABLE TD {
		width:40%;
		background-color: #FFF;
		text-align: left;
	}

-->
</STYLE>

<H1>Statistiques de l'année <?= date('Y') ?></H1>
<H2>Editée le <?= date('d') ?> <?= strftime('%B') ?></H2>

<H3>L'association en chiffres :</H3>

<table>
	<tr>
		<th>Nombre d'adhérents actifs : </th><td><?= count($adherents) ?></td>
	</tr>
	<tr>
		<th>Nombre d'animateurs : </th><td><?= count($adherentsAnimateur) ?></td>
	</tr>
	<tr>
		<th>Nombre d'adhérents en activité : </th><td><?= count($adherentsActif) ?></td>
	</tr>
	<tr>
		<th>Nombre de lieux : </th><td><?= count($lieux) ?></td>
	</tr>
	<tr>
		<th>Nombre de parcours : </th><td><?= count($parcours) ?></td>
	</tr>
	<tr>
		<th>Nombre de randonnées programmées : </th><td><?= count($Programmes) ?></td>
	</tr>
</table>

<H3>Statistiques de randonnées :</H3>

<script type="text/javascript" src="web/scripts/ejschart/dist/EJSChart.js"></script>
<link type="text/css" rel="stylesheet" href="web/scripts/ejschart/dist/EJSChart.css" />

<div id="myChart4a" class="chart" style="width:800px;height:400px;"></div>

<script type="text/javascript">
	var chart = new EJSC.Chart(
			"myChart4a", 
			{
				show_legend: false
			} 
		);

	var mySeries = new EJSC.BarSeries(
			new EJSC.ArrayDataHandler(
				[<?= getLstElements('entities\Programme',"valide = 1",$annee) ?>]
			) , 
			{
				orientation: "vertical",
				intervalOffset: .5,
				useColorArray: true
			}
		);

	mySeries.x_axis_formatter = new EJSC.NumberFormatter(
			{
				forced_decimals: 1
			} 
		);

	mySeries.y_axis_formatter = new EJSC.NumberFormatter(
			{
				forced_decimals: 2
			} 
		);

	chart.addSeries(mySeries);

</script>

<table>
	<tr>
		<th>Nombre de randonnées : </th><td><?= count($randonnees) ?></td>
	</tr>
	<tr>
		<th>Nombre de participants : </th><td><?= $nbparticipants ?></td>
	</tr>
	<tr>
		<th>Distance parcourue totale : </th><td><?= $nbkm ?> Km</td>
	</tr>
	<tr>
		<th>Dénivelée positive parcourue : </th><td><?= $nbdeniv ?> mètres</td>
	</tr>
 </table>

<H3>Statistiques administratives :</H3>

<table>
	<tr>
		<th>Chèques recus : </th><td><?= count($cheques) ?></td>
	</tr>
	<tr>
		<th>Somme totale reçue : </th><td><?= $totalSommeCheques ?> &euro;</td>
	</tr>
 </table>
