<?php
	use lib\DisplayEntity;
	use lib\security\Security;
	use entities\Programme;
	use entities\Reconnaissance;
	use entities\Membre;
	use entities\Reco_Participant;
	
	$reco = $Model['entity'];
	$action = "update";
	if ( $reco->id == null ) $action = "insert";
?>

<H1>Reconnaissance d'une randonnée</H1>
		
<ul class="Boutons">
	<?= DisplayEntity::displayBouton('retour','Retour') ?>
</ul>


	<?php
	if ( $reco->id_programme == null ) {
	?>

	<FORM class="autosubmit" name="selectLieu" action="_Reconnaissance_insert" method="POST" autocomplete="off">
	
		<H3>Selectionnez une prévision de randonnée pour commencer.</H3>
		
		<DIV class="table form">
			<DIV>
				<LABEL>Randonnée programmée : </LABEL>
				<SPAN>
					<?php
						//$filtre = "datedepart >= '".date('Y-m-d')."'";
						$filtre = "datedepart >= '2015-09-01'";
						$liste = Programme::selectList($filtre,'datedepart ASC');
						echo Programme::displayListSelect('id_programme',$liste);
					?>
				</SPAN>
			</DIV>
		</DIV>
	</FORM>
	
	<?php
	}
	else {
	?>
	
	<FORM id="formProgramme" name="formProgramme" class="form" action="_Reconnaissance_<?= $action ?>" method="POST" autocomplete="off" enctype="multipart/form-data">
	
		<DIV class="table form">

			<H2>Randonnée</H2>
			
			<DIV>
				<LABEL>Lieu : </LABEL>
				<SPAN><?= $reco->id_programme->id_randonnee ?></SPAN>
			</DIV>
			<DIV>
				<LABEL>Date : </LABEL>
				<SPAN><?= $reco->id_programme->getAttribut('datedepart')->date ?></SPAN>
			</DIV>
			<DIV>
				<LABEL>Responsable : </LABEL>
				<SPAN><?= $reco->id_programme->id_responsable ?></SPAN>
			</DIV>

			<H2>Départ de la reconnaissance</H2>

			<?php
				if ( $reco->etat == 0 || Security::isAdmin() || Security::isCoordinateur() )
				{
			?>
				<DIV>
					<LABEL>Date de la reconnaissance : </LABEL>
					<SPAN><input type="text" class="date" id="datereco" name="datereco" placeholder="dd/mm/yyy" value="<?= $reco->getAttribut('datereco')->date ?>" REQUIRED /></SPAN>
				</DIV>
				<DIV>
					<LABEL>Lieu de départ : </LABEL>
					<SPAN><input type="text" id="lieudepart" name="lieudepart" placeholder="Lieu de départ" value="<?= $reco->lieudepart ?>" REQUIRED /></SPAN>
				</DIV>
				<DIV>
					<LABEL>Nombre de Véhicule : </LABEL>
					<SPAN><input type="text" class="number" id="vehicule" name="vehicule" placeholder="Lieu de départ" value="<?= $reco->vehicule ?>" REQUIRED /></SPAN>
				</DIV>
				<DIV>
					<LABEL>Nombre de Véhicule de formation : </LABEL>
					<SPAN><input type="text" class="number" id="vehiculeFormation" name="vehiculeFormation" placeholder="Lieu de départ" value="<?= $reco->vehiculeFormation ?>" /></SPAN>
				</DIV>
				<DIV>
					<LABEL>Responsable : </LABEL>
					<SPAN>
						<?= Membre::displayListAnimateurs($reco->id_responsable->id,true) ?>
					</SPAN>
				</DIV>
			<?php
				}
				else
				{
			?>
				<DIV>
					<LABEL>Date de la reconnaissance : </LABEL>
					<SPAN><?= $reco->getAttribut('datereco')->date ?></SPAN>
				</DIV>
				<DIV>
					<LABEL>Lieu de départ : </LABEL>
					<SPAN><?= $reco->lieudepart ?></SPAN>
				</DIV>
				<DIV>
					<LABEL>Nombre de Véhicule : </LABEL>
					<SPAN><?= $reco->vehicule ?></SPAN>
				</DIV>
				<DIV>
					<LABEL>Nombre de Véhicule de formation : </LABEL>
					<SPAN><?= $reco->vehiculeFormation ?></SPAN>
				</DIV>
				<DIV>
					<LABEL>Responsable : </LABEL>
					<SPAN>
						<?= $reco->id_responsable ?>
					</SPAN>
				</DIV>
			<?php
				}
			?>
			<DIV>
				<LABEL>Validé : </LABEL>
				<SPAN><?= $reco->getAttribut('etat') ?></SPAN>
			</DIV>
			<?php if ( $action == "update" ) { ?>
			<DIV>
				<LABEL>Date de création : </LABEL>
				<SPAN>
					<?= $reco->getAttribut('datecreation')->date ?>
				</SPAN>
			</DIV>
			<DIV>
				<LABEL>Créateur : </LABEL>
				<SPAN>
					<?= $reco->id_createur ?>
				</SPAN>
			</DIV>
			<?php } ?>
			
<?php
/*
			<H2>
				Fichiers
				<UL class="tinyBoutons">
					<LI class="ajaxAdd add" data-url="_Fichier_add" data-idcible="fichiers" >Ajouter</LI>
				</UL>
			</H2>
			<?= $reco->getAttribut('fichiers')->displayCell($reco->id,true,true,'views/membre/displayPhoto.php') ?>
*/
?>
			
		</DIV>	
			
		<DIV class="table form">
			<H2>
				Parcours
			</H2>
				<?php 
					$cpt=1;
					foreach ( $reco->id_programme->parcours as $parcour ) 
					{
				?>
				<DIV>
					<LABEL>
						<INPUT type="hidden" id="id_parcour_<?= $cpt++ ?>" name="id_parcour[]" value="<?= $parcour->id ?>" />
					</LABEL>
					<SPAN><?= $parcour ?></SPAN>
				</DIV>
				<?php
					}
				?>
		</DIV>	
			
		<?php
			$datereco = new \DateTime($reco->datereco);
			$datejour = new \DateTime(date('Y-m-d'));
			$dateorig = new \DateTime('2000-01-01');
			if ( $datereco > $dateorig && $datereco <= $datejour )
			{
		?>
			<DIV class="table form">
				<H2>
					Synthèse 
				</H2>
				<DIV>
					<LABEL>Remarques : </LABEL>
					<SPAN>
						<TEXTAREA id="remarques" name="remarques[]" style="width:400px;height:150px;" >
							<?= ( $reco->synthese != null ) ? $reco->synthese->remarques : '' ?>
						</TEXTAREA>
						<INPUT type="hidden" name="syntheses" value="true" />
						<INPUT type="hidden" name="id_synthese[]" value="<?= ( $reco->synthese != null ) ? $reco->synthese->id : '' ?>" />
					</SPAN>
				</DIV>
			</DIV>
		<?php
			}
		?>
		
		<DIV id="participants">
			<H2>
				Participants
			</H2>
			<DIV>
				<SPAN id="formaddparticipant" name="formaddparticipant" class="form" >
					<INPUT type="text" id="nomparticipant" name="nomparticipant" list="lstAnimateurs" value="" />
					<INPUT type="hidden" id="id_reconnaissance" name="id_reconnaissance" value="<?= $reco->id ?>" />
					<UL class="tinyBoutons" data-formname="formaddparticipant">
						<li class="ajaxSearch add" data-url="_Reconnaissance_addParticipant" data-idcible="lstparticipants" data-idinput="#nomparticipant" title="Ajouter un participant">Ajouter</li>
					</UL>
					<input type="hidden" name="participants" value="true" />
				</SPAN>
			</DIV>
			<TABLE id="lstparticipants" data-pos="<?= count($reco->participants)+1 ?>" data-max="0" >
				<TR>
					<TH style="width:35%;">Adhérent</TH>
					<TH style="width:15%;">Licence</TH>
					<TH style="width:30%;">Groupes</TH>
					<TH style="width:15%;">Téléphone</TH>
					<TH style="width:5%;">Actions</TH>
				</TR>
				<?= $reco->afficheParticipants(true); ?>
			</TABLE>
		</DIV>
		
		<input type="hidden" name="validForm" value="formParcour" />
		<input type="hidden" name="id" value="<?= $reco->id ?>" />
		<input type="hidden" name="id_programme" value="<?= $reco->id_programme->id ?>" />
			
		<ul class="Boutons" data-formname="formProgramme">
			<li class="submit">Valider</li>
			<li class="cancel">Annuler</li>
		</ul>
		
	</FORM>
	
	<?php
	}
	?>

<DATALIST id="lstAnimateurs">
	<?= Membre::selectListForm('nom,prenom','id_etat NOT IN (7)','nom,prenom') ?>
</DATALIST>
