<?php
	use lib\DisplayEntity;
	use lib\security\Security;
	use entities\TypeRando;
	
	$reco = $Model['entity'];
	$action = "update";
	if ( $reco->id == null ) $action = "insert";
?>

<H1>Reconnaissance d'une randonnée</H1>
		
<ul class="Boutons" data-formname="formParcour">
	<?php
		$datereco = new \DateTime($reco->datereco);
		$datejour = new \DateTime(date('Y-m-d'));
		echo DisplayEntity::displayBouton('bouton','Mails','Mail','formMailing','mail','idReco='.$reco->id,"Envois de courriels aux participants") ;
		if ( $reco->etat == 0 || ( $reco->synthese != null && $reco->synthese->remboursement == 0 ) || ( $reco->synthese == null && $datejour >= $datereco ) ) {
			echo DisplayEntity::displayBouton('bouton','Modifier/Synthèse','Reconnaissance','update','edit','id='.$reco->id,"Modification/Synthèse de la reconnaissance",null,null,$reco) ; 
			if ( $reco->etat == 1 && $reco->synthese != null ) {
				echo DisplayEntity::displayBouton('bouton','Frais','Reconnaissance','frais','payer','id='.$reco->id,"Saisie des frais de la reconnaissance") ;
			}
		}
		echo DisplayEntity::displayBouton('bouton','Supprimer','Reconnaissance','delete','delete','id='.$reco->id,"Supprimer le programme") ;
		echo DisplayEntity::displayBouton('retour','Retour') 
	?>
</ul>

<DIV class="table form">

	<H2>Randonnée</H2>

	<DIV>
		<LABEL>Lieu : </LABEL>
		<SPAN><?= $reco->id_programme->id_randonnee ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Date : </LABEL>
		<SPAN><?= $reco->id_programme->getAttribut('datedepart')->date ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Responsable : </LABEL>
		<SPAN><?= $reco->id_programme->id_responsable ?></SPAN>
	</DIV>

	<H2>Départ de la reconnaissance</H2>

	<DIV>
		<LABEL>Date de la reconnaissance : </LABEL>
		<SPAN><?= $reco->getAttribut('datereco')->date ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Lieu de départ : </LABEL>
		<SPAN><?= $reco->lieudepart ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Nombre de véhicules : </LABEL>
		<SPAN><?= $reco->vehicule ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Nombre de véhicules de formation : </LABEL>
		<SPAN><?= $reco->vehiculeFormation ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Responsable : </LABEL>
		<SPAN><?= $reco->id_responsable ?> (tel : <?= $reco->id_responsable->telephone ?> / portable : <?= $reco->id_responsable->portable ?>)</SPAN>
	</DIV>
	<DIV>
		<LABEL>Etat : </LABEL>
		<SPAN><?= $reco->getAttribut('etat') ?></SPAN>
	</DIV>
	<?php 
		if ( $action == "update" ) { 
	?>
	<DIV>
		<LABEL>Date de création : </LABEL>
		<SPAN><?= $reco->getAttribut('datecreation')->date ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Créateur : </LABEL>
		<SPAN><?= $reco->id_createur ?></SPAN>
	</DIV>
	<?php 
		} 
	?>
	
	<H2>Fichiers</H2>
	<?= $reco->getAttribut('fichiers')->displayCell($reco->id,false,false,'views/fichier/displayElmt.php') ?>

	<?php
		if ( $reco->synthese != null ) 
		{ 
	?>
	
	<H2>Synthèse</H2>
	
	<DIV>
		<LABEL>Remarques : </LABEL>
		<SPAN><?= $reco->synthese ?></SPAN>
	</DIV>
	
	<H2>Remboursement de frais</H2>
	
	<?php 
			for ( $cpt = 1; $cpt <= $reco->vehicule; $cpt++) 
			{
				$col = 'vehicule'.$cpt;
		?>
			<DIV>
				<LABEL>Véhicule <?= $cpt ?> : </LABEL>
				<SPAN><?= ( $reco->synthese->$col == 1 ) ? 'Oui' : 'Non' ?></SPAN>
			</DIV>
		<?php
			}
			if ( $reco->vehiculeFormation > 0 )
			{
		?>
			<DIV>
				<LABEL>Véhicule de formation : </LABEL>
				<SPAN><?= ( $reco->synthese->vehiculeFormation == 1 ) ? 'Oui' : 'Non' ?></SPAN>
			</DIV>
		<?php
			}
		}
	?>
	
	<H2>Parcours liés</H2>

		
	<?php 
		$cpt=1;
		foreach ( $reco->id_programme->parcours as $parcour ) 
		{
	?>
		<DIV>
			<SPAN><?= $parcour ?></SPAN>
		</DIV>
	<?php
		}
	?>
	
	<DIV class="table">
		<H2>
			Participants :
		</H2>
		<TABLE>
			<TR>
				<TH style="width:35%;">Adhérent</TH>
				<TH style="width:15%;">Licence</TH>
				<TH style="width:30%;">Groupes</TH>
				<TH style="width:15%;">Téléphone</TH>
			</TR>
			<?= $reco->afficheParticipants(); ?>
		</TABLE>
	</DIV>	

		
</DIV>
