<?php
	use lib\DisplayEntity;
	use lib\security\Security;
	use entities\Reco_Participant;
	use entities\Membre;
	
	$reco = $Model['entity'];
	$action = "update";
	if ( $reco->id == null ) $action = "insert";
?>

<H1>Gestion des participants à la reconnaissance</H1>
		
<ul class="Boutons" data-formname="formParticipant">
	<?php
		if ( $reco->isProprio() || Security::isAdmin() || Security::isCoordinateur() ) 
		{
	?>
		<?= DisplayEntity::displayBouton('bouton','Mails','Mail','formMailing','mail','idReco='.$reco->id,"Envois de courriels aux participants") ?>
		<?= DisplayEntity::displayBouton('bouton','Imprimer la liste','Edition','printRecoParticipants','print','idProgramme='.$reco->id,"Imprimer la liste") ?>
	<?php
		}
	?>
	<?= DisplayEntity::displayBouton('retour','Page précédente') ?>
</ul>

<DIV class="table form">

	<H3><?= count($reco->participants) ?> Participants</H3>

	<?php
		if ( Security::isAdmin() || Security::isCoordinateur() || $reco->isResponsable() )
		{
	?>
	
	<H2>
		Ajouter un participant
	</H2>

	<DIV>
		<FORM id="formParticipant" name="formParticipant" class="form" action="_Reconnaissance_addParticipant" method="POST" autocomplete="off" enctype="multipart/form-data">
			<SPAN>
				<INPUT type="text" id="nomparticipant" name="nomparticipant" list="lstMembres" value="" />
				<INPUT type="hidden" id="id_reconnaissance" name="id_reconnaissance" value="<?= $reco->id ?>" />
				<UL class="tinyBoutons" data-formname="formParticipant">
					<?= DisplayEntity::displayBouton('submit','Ajouter') ?>
				</UL>
			</SPAN>
		</FORM>
	</DIV>

	<?php
		}
	?>

	<DIV id="participants" data-pos="<?= count($reco->participants)+1 ?>" data-max="<?= $reco->nbplaces - $reco->inscrits ?>">

		<H2>liste des participants</H2>
		<TABLE>
			<TR>
				<TH style="width:35%;">Adhérent</TH>
				<TH style="width:15%;">Licence</TH>
				<TH style="width:30%;">Groupes</TH>
				<TH style="width:15%;">Téléphone</TH>
				<TH style="width:5%;">Actions</TH>
			</TR>
			<?= $reco->afficheParticipants(true); ?>
		</TABLE>
	</DIV>
		
</DIV>

<DATALIST id="lstMembres">
	<?= Membre::selectListForm('nom,prenom','id_etat IN (1,2,5,8)','nom,prenom') ?>
</DATALIST>
