<?php
	use lib\DisplayEntity;
	use entities\Randonniere;
	use entities\Membre;
	$randonniere = $Model['entity'];
	$date = Datetime::createFromFormat('d/m/Y', $randonniere->getAttribut('date_event')->date );
?>

<SCRIPT type="text/javascript">
$(document).ready( function() {
	$('#type_event').change(function(){
		var type = $(this).find("option:selected").val();
		var action = $(this).data('action');
		var date = $(this).data('date');
		document.location.href="_Calendrier_"+action+"&type_event="+type+"&date="+date ;
	});
});
</SCRIPT>
		
<H1>Gestion de la Randonnière</H1>
		
<ul class="Boutons" data-formname="formEvent">
	<?= DisplayEntity::displayBouton('bouton','Modifier','Calendrier','update','edit','id='.$randonniere->id,"Modifier l'évènement") ?>
	<?= DisplayEntity::displayBouton('bouton','Supprimer','Calendrier','delete','delete','id='.$randonniere->id,"Supprimer l'évènement") ?>
	<?= DisplayEntity::displayBouton('retour','Retour') ?>
</ul>

<DIV class="table form">
	
	<H2>Réservation pour la date du <?= $randonniere->getAttribut('date_event')->date ?></H2>
	
	<DIV>
		<LABEL>Type d'évènement : </LABEL>
		<SPAN><?= $randonniere->getAttribut('type_event') ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Heure de début : </LABEL>
		<SPAN><?= $randonniere->getAttribut('datestart_event')->heureMin ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Heure de fin : </LABEL>
		<SPAN><?= $randonniere->getAttribut('dateend_event')->heureMin ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Descripton : </LABEL>
		<SPAN><?= $randonniere->description_event ?></SPAN>
	</DIV>
	
	<?php
		if ( $randonniere->type_event == 0 )
		{
	?>
		<DIV>
			<LABEL>
				Permanences / Animateurs : 
			</LABEL>
			<SPAN id="lstPermanenciers" data-pos="<?= count($randonniere->permanenciers)+1 ?>" data-max="0">
				<?php $randonniere->displayPermanenciers(); ?>
			</SPAN>
		</DIV>
	<?php
		}
		elseif ( $randonniere->type_event == 1 )
		{
	?>
		<DIV>
			<LABEL>Nom du responsable : </LABEL>
			<SPAN><?= $randonniere->id_responsable ?></SPAN>
		</DIV>
	<?php
		}
	?>
	
</DIV>
