<?php	
	use lib\DisplayEntity;
	use entities\Randonnee;
	
	$lstEntities  = $Model['lstEntities'];
	$recherche    = ( isset($Model['recherche']) ) ? $Model['recherche'] : '';
	$departement  = ( isset($Model['departement']) ) ? $Model['departement'] : null;
/*	$id_role      = ( isset($Model['id_role']) ) ? $Model['id_role'] : null;
	$actif        = ( isset($Model['actif']) ) ? 'CHECKED' : '' ;
	$datecreation = ( isset($Model['datecreation']) ) ? $Model['datecreation'] : '';
*/
?>
<H1>Gestion des randonnées</H1>
<H2>Liste des lieux de randonnées</H2>

<p>Bienvenue sur la page de gestion des Randonnees. Le tableau ci-dessous contient les lieux sur lesquels vous pouvez randonner.</p>
<p>pour créer une prévision de randonnée, recherchez le lieu dans la liste ci-dessous. Creez votre prévision avec le bouton <q>+</q>. 
Si le lieu n'existe dans la liste, utilisez le bouton "ajouter un lieu" pour le créer.</p>

<ul class="Boutons" data-formname="formAddFile">
	<?= DisplayEntity::displayBouton('bouton','Ajouter un lieu','Randonnee','insert','add',null,"Ajouter un lieu de randonnée") ?>
	<?= DisplayEntity::displayBouton('bouton','Imprimer le tableau','Randonnee','lstPrint','print',null,"Imprimer le tableau") ?>
	<?= DisplayEntity::displayBouton('retour','Page précédente') ?>
</ul>

<H3><?= count($lstEntities) ?> lieux et <?= Randonnee::countParcours($lstEntities) ?> parcours ont été trouvé(s) !</H3>

<form class="formfiltre autosubmit" name="filtreRandonnee" action="_Randonnee_list" method="POST" autocomplete="off">
	<h4>Filtres ...</h4>
	<?= Randonnee::displayListDepartements($departement) ?>
	<input type="text" name="recherche" placeholder="Chaine à rechercher (Commune, lieu)" value="<?= $recherche ?>" />
	<input type="hidden" name="validForm" value="formFiltre" />
</form>

<?php 
	$Model['onglet'] = 'randonnees';
	include "views/ongletsRandos.php"; 
?>

<TABLE width="100%" border="0">

    <TR class="ligneHeader">
		<TH style="width:5%;">Départ.</TH>
		<TH style="width:15%;">Commune</TH>
		<TH style="width:20%;">Lieu</TH>
		<TH style="width:5%;">Date rando.</TH>
		<TH style="width:7%;"></TH>
		<TH style="width:48%;">Parcours</TH>
	</TR>
	
<?php
	$bgcolor = false;
	foreach( $lstEntities as $entity) 
	{
		$class = '';
		if ($bgcolor) $class = 'class="tabLigneBg"';
		$bgcolor = !$bgcolor;
?>

    <TR <?=$class ?> >
		<TD class="alignCenter"><?= $entity->departement ?></TD>
		<TD><?= $entity->commune ?></TD>
		<TD><?= $entity->lieu ?></TD>
		<TD><?= substr($entity->datelastrando,3) ?></TD>
		<TD class="alignCenter">
			<UL class="BtnsIco">
				<?= DisplayEntity::displayBouton('bouton','','Programme','insert','add','id_randonnee='.$entity->id,"Programmer une randonnée pour ce lieu") ?>
				<?= DisplayEntity::displayBouton('bouton','','Randonnee','display','display','id='.$entity->id,"Détail du site de randonnée") ?>
				<?= DisplayEntity::displayBouton('bouton','','Randonnee','delete','delete','id='.$entity->id,"Supprimer le site de randonnée") ?>
			</UL>
		</TD>
		<TD><?= $entity->getAttribut('parcours')->affiche(0,true) ?></TD>
	<TR>

<?php
	}
?>
	
</TABLE>
