<?php
	use lib\DisplayEntity;
	use entities\TypeRando;
	$rando = $Model['entity'];
	$action = "update";
	if ( $rando->id == null ) $action = "insert";
?>

<H1>Lieu de randonnée</H1>
	
<ul class="Boutons">
	<?= DisplayEntity::displayBouton('retour','Retour') ?>
</ul>

<form id="formRando" name="formRando" class="form" action="_Randonnee_<?= $action ?>" method="POST" autocomplete="off" enctype="multipart/form-data">

	<DIV class="table form">

		<H2>Formulaire</H2>

		<DIV>
			<LABEL>Département : </LABEL>
			<SPAN><input type="text" id="departement" name="departement" placeholder="Dpt" value="<?= $rando->departement ?>" REQUIRED /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Commune : </LABEL>
			<SPAN><input type="text" id="commune" name="commune" placeholder="Commune" value="<?= $rando->commune ?>" REQUIRED /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Lieu : </LABEL>
			<SPAN><input type="text" id="lieu" name="lieu" placeholder="Lieu" value="<?= $rando->lieu ?>" REQUIRED /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Type de randonnée : </LABEL>
			<SPAN>
				<?= TypeRando::displayList((($rando->id_typerando != null) ? $rando->id_typerando->id : 1),true) ?>
			</SPAN>
		</DIV>
		<?php if ( $action == "update" ) { ?>
		<DIV>
			<LABEL>Date de création : </LABEL>
			<SPAN>
				<?= $rando->getAttribut('datecreation')->date ?>
			</SPAN>
		</DIV>
		<DIV>
			<LABEL>Créateur : </LABEL>
			<SPAN>
				<?= $rando->id_createur ?>
			</SPAN>
		</DIV>
		<DIV>
			<LABEL>Parcours : </LABEL>
			<SPAN id="parcours">
				<?= $rando->getAttribut('parcours')->affiche() ?>
			</SPAN>
		</DIV>
		<?php } ?>
	</DIV>	

	<input type="hidden" name="validForm" value="formRando" />
	<input type="hidden" name="id" value="<?= $rando->id ?>" />
		
	<ul class="Boutons" data-formname="formRando">
		<li class="submit">Valider</li>
		<li class="cancel">Annuler</li>
	</ul>
	
</form>

