<?php	
	use lib\DisplayEntity;
	use lib\attributs\DateHeure;
	use lib\security\Security;
	use entities\Membre;
	use entities\Randonnee;
	use entities\TypeRando;
	use entities\Reconnaissance;
	
	$lstEntities  = $Model['lstEntities'];
	$id_responsable = ( isset($Model['id_responsable']) ) ? $Model['id_responsable'] : 0;
	$id_typerando   = ( isset($Model['id_typerando']) )   ? $Model['id_typerando']   : 0;
	$datedebut      = ( isset($Model['datedebut']) ) ? $Model['datedebut'] : '';
	$datefin        = ( isset($Model['datefin']) ) ? $Model['datefin'] : '';
?>
<H1>Gestion des randonnées</H1>

<p>Bienvenue sur la page de gestion des Randonnees. Le tableau ci-dessous contient les randonnées programmées pour les mois à venir.</p>
<p>Pour créer une reconnaissance, cliquer sur le bouton <q>+</q> de votre prévision de randonné.</p>
<p>Pour créer une prévision de randonnée, positionnez vous sur l'onglet <b><q>Lieux de randonnées</q></b>.</p>

<ul class="Boutons">
	<?= '' //DisplayEntity::displayBouton('bouton','Ajouter une prévision','Programme','insert','add',null,"Ajouter une prévision") ?>
	<?= DisplayEntity::displayBouton('bouton','Imprimer le tableau','Programme','lstPrint','print',null,"Imprimer le tableau") ?>
	<?= DisplayEntity::displayBouton('retour','Page précédente') ?>
</ul>

<H2>Liste des randonnées programmées</H2>

<H3><?= count($lstEntities) ?> randonnée(s) programmée(s) !</H3>

<form class="formfiltre autosubmit" name="filtreProgramme" action="_Programme_list" method="POST" autocomplete="off">
	<h4>Filtres ...</h4>
	<DIV>
		<?= Membre::displayListAnimateurs($id_responsable,false,'id_responsable') ?>
		<label>Randonnées prévues entre le ... </label><input type="text" class="date" name="datedebut" placeholder="jj/mm/yyyy" value="<?= $datedebut ?>" />
		<label>et le ... </label><input type="text" class="date" name="datefin" placeholder="jj/mm/yyyy" value="<?= $datefin ?>" />
		<input type="hidden" name="validForm" value="formFiltre" />
		<?= TypeRando::displayList($id_typerando,false) ?>
	</div>
</form>

<?php 
	include "views/ongletsRandos.php"; 
?>

<TABLE width="100%" border="0">
    <TR class="ligneHeader">
		<TH style="width:7%;">Date.</TH>
		<TH style="width:28%;">Lieu</TH>
		<TH style="width:35%;">Parcours</TH>
		<TH style="width:15%;">Responsable</TH>
		<TH style="width:11%;">Actions</TH>
		<TH style="width:4%;">Etat</TH>
	</TR>
</TABLE>
	
<?php
	$bgcolor = false;
	$mois = 0;
	foreach( $lstEntities as $entity) 
	{
		$class = '';
		if ($bgcolor) $class = 'class="tabLigneBg"';
		$bgcolor = !$bgcolor;
		$moiscour = $entity->getAttribut('datedepart')->mois;
		$anneecour = $entity->getAttribut('datedepart')->annee;
		
		if ( !empty($mois) && $mois != $moiscour )
		{
		?>
			</TABLE>
		<?php
		}
		
		if ( empty($mois) || $mois != $moiscour ) 
		{
			$mois = $moiscour;
		?>
			<TABLE width="100%" border="0">
				<CAPTION>Randonnées pour le mois de <?= DateHeure::getLibelleMois(intval($mois)) ?> <?= $anneecour ?></CAPTION>
		<?php
		}
?>

    <TR <?=$class ?> >
		<TD style="width:7%;" class="alignCenter"><?= $entity->getAttribut('datedepart')->date ?></TD>
		<TD style="width:28%;"><?= $entity->randonnee ?></TD>
		<TD style="width:35%;"><?= $entity->getAttribut('parcours') ?></TD>
		<TD style="width:15%;"><?= $entity->responsable ?></TD>
		<TD style="width:11%;" class="alignCenter">
			<UL class="BtnsIco">
				<?php
					$dateSortie = new \DateTime($entity->datedepart);
					$dateJour   = new \DateTime(date('Y-m-d'));
					echo DisplayEntity::displayBouton('bouton','','Programme','display','display','id='.$entity->id,"Détail du programme de randonnée");
					if ( $entity->valide != 1 || Security::isAdmin() || Security::isCoordinateur() ) {
						if ( $entity->valide != 3 ) {
							if ( $entity->synthese == null && $dateSortie > $dateJour ) {
								echo DisplayEntity::displayBouton('bouton','','Programme','update','edit','id='.$entity->id,"Modifier le programme de randonnée",null,null,$entity); 
							}
							elseif ( $entity->synthese == null || $entity->synthese->valide != 1 ) {
								echo DisplayEntity::displayBouton('bouton','','Programme','synthese','edit','id='.$entity->id,"Synthese de la randonnée",null,null,$entity); 
							}
							echo DisplayEntity::displayBouton('bouton','','Programme','delete','delete','id='.$entity->id,"Supprimer le programme de randonnée");
						}
					}
					if ( $entity->valide == 3 ) {
						echo DisplayEntity::displayBouton('bouton','','Programme','reactivation','archive','id='.$entity->id,"Restaurer un programme de randonnée");
					}
					else {
						echo DisplayEntity::displayBouton('bouton','','Programme','cancel','archive','id='.$entity->id,"Annuler un programme de randonnée");
					}
					if ( ! Reconnaissance::exist( 'id_programme = '.$entity->id ) || Security::isCoordinateur() ) {
						echo DisplayEntity::displayBouton('bouton','','Reconnaissance','insert','add','id_programme='.$entity->id,"Créer une reconnaissance");
					}
				?>
			</UL>
		</TD>
		<TD style="width:4%;" class="alignCenter">
			<?php 
				$img = 'web/images/icones/100.png"';
				if ( $entity->valide == 0 || ( $entity->synthese != null && $entity->synthese->valide == 0 ) ) $img = 'web/images/icones/115.png"';
				$img = '<IMG style="width:18px;" src="'.$img.'" />';
				$url = $img;
				if ( Security::isCoordinateur() || Security::isGestionnaire() || Security::isAdmin() ) 
				{ 
					if ( $entity->valide == 0 ) $url = '<A href="_Programme_valide&id='.$entity->id.'" title="Valider la programmation">'.$img.'</A>';
					if ( $entity->synthese != null && $entity->synthese->valide == 0 ) $url = '<A href="_Programme_valideSynthese&id='.$entity->id.'" title="Valider la synthese">'.$img.'</A>';
				}
				echo $url;
			?>
		</TD>
	<TR>

<?php
	}
?>
	
</TABLE>
