<?php
	use lib\DisplayEntity;
	use lib\security\Security;
	use entities\Parcour;
	use entities\Randonnee;
	use entities\TypeRando;
	use entities\Membre;
	use entities\Personne;
	use entities\Programme_Animateur;
	
	$programme = $Model['entity'];
	$action = "update";
	if ( $programme->id == null )  $action = "insert";
	if ( isset($Model['action']) ) $action = $Model['action'];
	$rando = $programme->randonnee;
?>

<H1>Programme de randonnée</H1>
		
<ul class="Boutons">
	<?= DisplayEntity::displayBouton('retour','Retour') ?>
</ul>

<FORM class="autosubmit" name="selectLieu" method="POST" autocomplete="off">

	<DIV class="table form">

		<H2>
			Lieu de la randonnée
			<UL class="tinyBoutons">
				<?= DisplayEntity::displayBouton('ajaxOpen','Ajouter','Randonnee','add','add',null,"Ajouter un lieu") ?>
			</UL>
		</H2>
	
		<DIV id="randonee">
			<?php include "views/randonnee/displayCell.php"; ?>
		</DIV>
	</DIV>
</FORM>

<FORM id="formProgramme" name="formProgramme" class="form" action="_Programme_<?= $action ?>" method="POST" autocomplete="off" enctype="multipart/form-data">

<?php
	if ( !empty($rando) && $rando->id != null ) 
	{
?>

	<DIV class="table form">

		<H2>Départ</H2>

		<DIV>
			<LABEL>Date de la sortie : </LABEL>
			<SPAN><input type="text" class="date" id="datedepart" name="datedepart" placeholder="dd/mm/yyyy" value="<?= $programme->getAttribut('datedepart')->date ?>" REQUIRED /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Heure de départ : </LABEL>
			<SPAN><input type="text" class="time" id="heuredepart" name="heuredepart" placeholder="hh:mm" value="<?= $programme->getAttribut('heuredepart')->heureMin ?>" REQUIRED /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Commune de départ : </LABEL>
			<SPAN><input type="text" id="communedepart" name="communedepart" placeholder="Commune de départ" value="<?= $programme->communedepart ?>" REQUIRED /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Lieu de départ : </LABEL>
			<SPAN><input type="text" id="depart_lieu" name="depart_lieu" placeholder="Lieu de départ (ou O.Tourisme )" value="<?= $programme->depart_lieu ?>" REQUIRED /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Véhicule : </LABEL>
			<SPAN>
				<SELECT name="vehicule">
					<OPTION value="VP"  <?= ($programme->vehicule == 'VP')  ? 'SELECTED' : '' ?> >En véhicule personnel</OPTION>
					<OPTION value="CAR" <?= ($programme->vehicule == 'CAR') ? 'SELECTED' : '' ?> >En car</OPTION>
				</SELECT>
			</SPAN>
		</DIV>
		<DIV>
			<LABEL>Nombre de places : </LABEL>
			<SPAN><input type="text" class="number" id="nbplaces" name="nbplaces" value="<?= $programme->nbplaces ?>" REQUIRED /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Responsable : </LABEL>
			<SPAN>
				<?= Membre::displayListAnimateurs($programme->id_responsable->id,true) ?>
			</SPAN>
		</DIV>
		<DIV>
			<LABEL>Inscriptions  : </LABEL>
			<SPAN>
				<DIV class="ligneOption form" id="inscription">
					<DIV class="displayElmt ligneTab" style="width:420px;<?= ( $programme->id_inscription != null ) ? 'display:none;' : 'display:inline-block;' ?>">
						<LABEL>
							Aucune inscription nécessaire pour cette randonnéee
						</LABEL>
						<SPAN>
							<UL class="BtnsIco">
								<LI class="switchEdit"  data-idbloc="#inscription" title="Ajouter une inscription"></LI>
							</UL>
						</SPAN>
					</DIV>
					<DIV class="editElmt" style="width:420px;<?= ( $programme->id_inscription != null ) ? 'display:inline-block;' : 'display:none;' ?>">
						<LABEL class="table">
							<DIV>
								<LABEL style="width:150px;">Responsable  : </LABEL>
								<SPAN>
									<?php
										if ( $programme->id_inscription != null ) {
											echo Membre::displayListAnimateurs($programme->id_inscription->id,false,'id_inscription','onChange=\'$("#telinscription").val("")\'');
										}
										else {
											echo Membre::displayListAnimateurs(0,false,'id_inscription','onChange=\'$("#telinscription").val("")\'');
										}
									?>
								</SPAN>
							</DIV>
							<DIV>
								<LABEL style="width:150px;">Téléphone : </LABEL>
								<SPAN><input type="text" class="tel" id="telinscription" name="telinscription" placeholder="ex : 06 04 32 54 18" value="<?= $programme->telinscription ?>" /></SPAN>
							</DIV>
							<DIV>
								<LABEL style="width:150px;">Date de début : </LABEL>
								<SPAN><input type="text" class="date" id="dateinscription" name="dateinscription" placeholder="jj/mm/yyyy" value="<?= $programme->getAttribut('dateinscription')->date ?>" /></SPAN>
							</DIV>
						</LABEL>
						<SPAN>
							<UL class="BtnsIco">
								<LI  data-pos="<?= "inscription" ?>" title="Sans inscription" onClick="$('#telinscription').val('');$('#dateinscription').val('');$('#id_inscription option:first').prop('selected','selected');"></LI>
							</UL>
						</SPAN>
					</DIV>
				</DIV>
			
			
			</SPAN>
		</DIV>
		<DIV>
			<LABEL>Note : </LABEL>
			<SPAN><TEXTAREA id="note" name="note"><?= $programme->note ?></TEXTAREA></SPAN>
		</DIV>
		<DIV>
			<LABEL>Validé : </LABEL>
			<SPAN>
				<?= $programme->getAttribut('valide') ?>
				<input type="hidden" name="valide" value="<?= $programme->valide ?>" />
			</SPAN>
		</DIV>
		<?php if ( $action != "insert" ) { ?>
		<DIV>
			<LABEL>Date de création : </LABEL>
			<SPAN>
				<?= $programme->getAttribut('datecreation')->date ?>
				<input type="hidden" name="datecreation" value="<?= $programme->getAttribut('datecreation')->date ?>" />
			</SPAN>
		</DIV>
		<DIV>
			<LABEL>Créateur : </LABEL>
			<SPAN>
				<?= $programme->id_createur ?>
			</SPAN>
		</DIV>
		<?php } ?>

	</DIV>	
		
	<?php
		$action = "update";
	?>
	<DIV class="table">
		<H2>
			Parcours
			<UL class="tinyBoutons">
				<?= DisplayEntity::displayBouton('ajaxOpen','Ajouter','Parcour','add','add','idRando='.$rando->id.'&idProgramme='.$programme->id,"Ajouter un parcours",'parcours') ?>
			</UL>
		</H2>
		
		<?= $programme->getAttribut('parcours')->displayCell($programme->id,true,true,'views/parcour/displayElmt.php') ?>

	</DIV>	

<?php
	}
?>	
	<input type="hidden" name="validForm" value="formProgramme" />
	<input type="hidden" name="id" value="<?= $programme->id ?>" />
	<input type="hidden" name="id_randonnee" value="<?= ( empty($rando) ) ? 0 : $rando->id ?>" />
		
	<br />
	<h6>Après validation vous pourrez saisir votre reconnaissance en cliquant sur le bouton <q>+</q> de votre prévision de randonnée 
	depuis la liste des <q>Randonnées prévues</q>.</h6>

	<ul class="FormBoutons" data-formname="formProgramme">
		<li class="submit">Valider</li>
		<li class="cancel">Annuler</li>
	</ul>

</FORM>

<DATALIST name="lstAnimateurs" id="lstAnimateurs">

	<?= Membre::selectListForm('nom,prenom','id_etat IN (1,2) AND id IN (SELECT id_membre FROM gari_role_membre WHERE id_role = 2)','nom,prenom') ?>
	
</DATALIST>
