<?php
	use lib\DisplayEntity;
	use lib\security\Security;
	use entities\TypeRando;
	
	$programme = $Model['entity'];
	$action = "display";
?>

<H1>Programme de randonnée</H1>
	
<ul class="Boutons" data-formname="formParcour">
	<?php
		echo DisplayEntity::displayBouton('retour','Retour');
		$dateSortie = new \DateTime($programme->datedepart);
		$dateJour   = new \DateTime(date('Y-m-d'));
		if ( $programme->valide == 0 || $programme->valide == 1 ) 
		{
			echo DisplayEntity::displayBouton('bouton','Annuler','Programme','cancel','archive',$programme->idClause,"Annuler un programme de randonnée");
			echo DisplayEntity::displayBouton('bouton','Participants','Programme','participants','user',$programme->idClause,"Gestion des participants au programme",null,null,$programme);
			echo DisplayEntity::displayBouton('bouton','Fichiers','Programme','listFichiers','image',$programme->idClause,"Liste des fichiers associés au programme de randonnée");
			if ( $dateSortie <= $dateJour && ( $programme->synthese == null || $programme->synthese->valide != 1 ) )
			{
				echo DisplayEntity::displayBouton('bouton','Synthese','Programme','synthese','edit',$programme->idClause,"Synthese de la randonnée",null,null,$programme); 
			}
		}
		elseif ( $programme->valide == 3 ) 
		{
			echo DisplayEntity::displayBouton('bouton','Restaurer','Programme','reactivation','archive',$programme->idClause,"Restaurer un programme de randonnée");
		}
		if ( $programme->valide == 0 || Security::isAdmin() || Security::isCoordinateur() ) 
		{
			if ( $programme->synthese == null && $dateSortie > $dateJour ) 
			{
				echo DisplayEntity::displayBouton('bouton','Modifier','Programme','update','edit',$programme->idClause,"Modifier le programme",null,null,$programme); 
			}
			echo DisplayEntity::displayBouton('bouton','Supprimer','Programme','delete','delete',$programme->idClause,"Supprimer le programme");
		}
	?>
</ul>

<DIV class="table form">

	<H2>Lieu de la randonnée</H2>

	<DIV>
		<LABEL>Type de randonnée : </LABEL>
		<SPAN><?= $programme->id_randonnee->id_typerando ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Département : </LABEL>
		<SPAN><?= $programme->id_randonnee->departement ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Commune : </LABEL>
		<SPAN><?= $programme->id_randonnee->commune ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Lieu : </LABEL>
		<SPAN><?= $programme->id_randonnee->lieu ?></SPAN>
	</DIV>

	<H2>Départ</H2>

	<DIV>
		<LABEL>Date de la sortie : </LABEL>
		<SPAN><?= $programme->getAttribut('datedepart')->date ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Heure de départ : </LABEL>
		<SPAN><?= $programme->getAttribut('heuredepart')->heureMin ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Commune de départ : </LABEL>
		<SPAN><?= $programme->communedepart ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Lieu de départ : </LABEL>
		<SPAN><?= $programme->depart_lieu ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Véhicule : </LABEL>
		<SPAN><?= $programme->vehicule ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Nombre de places : </LABEL>
		<SPAN><?= $programme->nbplaces ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Responsable : </LABEL>
		<SPAN><?= $programme->id_responsable ?> (tel : <?= $programme->id_responsable->telephone ?> / portable : <?= $programme->id_responsable->portable ?>)</SPAN>
	</DIV>
	<DIV>
		<LABEL>Inscriptions  : </LABEL>
		<SPAN>
			<?php
				if ( $programme->id_inscription != null ) {
					$respInscriptions = $programme->id_inscription;
					$telInscriptions  = $programme->telinscription;
					echo $respInscriptions;
					echo " à contacter au ".$telInscriptions;
					echo " à partir du ".$programme->getAttribut('dateinscription')->date;
				} else {
					echo "Aucune inscription nécessaire";
				}
			?>
		</SPAN>
	</DIV>
	<DIV>
		<LABEL>Note : </LABEL>
		<SPAN><?= $programme->note ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Etat : </LABEL>
		<SPAN><?= $programme->getAttribut('valide') ?></SPAN>
	</DIV>
	<?php 
		if ( $action == "update" ) { 
	?>
	<DIV>
		<LABEL>Date de création : </LABEL>
		<SPAN><?= $programme->getAttribut('datecreation')->date ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Créateur : </LABEL>
		<SPAN><?= $programme->id_createur ?></SPAN>
	</DIV>

	<?php 
		} 
	?>

	<?php
		if ( $programme->synthese != null ) 
		{ 
	?>
	
	<H2>Synthèse</H2>
	
	<DIV>
		<LABEL>Remarques : </LABEL>
		<SPAN><?= $programme->synthese->remarques ?></SPAN>
	</DIV>
	
	<DIV>
		<LABEL>Notes : </LABEL>
		<SPAN><?= $programme->synthese->anoter ?></SPAN>
	</DIV>

	<?php
		}
	?>
	
	<H2>Parcours liés</H2>

	<DIV>
		<?= $programme->getAttribut('parcours')->displayCell($programme->id,false,false,'views/parcour/displayElmt.php') ?>
	</DIV>

	<DIV>
		<H2>liste des participants</H2>
		<H3> <?= $programme->inscrits ?> Participants sur <?= $programme->nbplaces ?> places prévues (<?= $programme->enAttente ?> personnes en attente)</H3>
		<TABLE>
			<?php 
				$Model['boutons'] = false;
				$Model['ventile'] = false;
				$Model['attente'] = 0;
				include "views/participant/displayCellTitle.php"; 
			?>
			<?= $programme->afficheParticipants(0,false,false); ?>
		</TABLE>
		<H2>Liste d'attente</H2>
		<TABLE>
			<?php 
				$Model['boutons'] = false;
				$Model['ventile'] = false;
				$Model['attente'] = 1;
				include "views/participant/displayCellTitle.php"; 
			?>
			<?= $programme->afficheParticipants(1,false,false); ?>
		</TABLE>
	</DIV>

		
</DIV>
