<?php
	/**
	* Vue gérant l'affichage d'un formulaire générique d'insertion et de mise à jour d'une Enitée
	*
	* @copyright  Copyright (c) 2015 DYNAVEO, COnseils et Services en Informatique
	* @author Patrice Cuissard
	* @version    1.0
	*/
	
	use lib\DisplayEntity;

	$entity = $Model['entity'];					// On récupère l'entité dans le tableau associatif Global $Model
?>
<div id="deleteEntity">

	<h2>Supression d'une programmation de randonnée</h2>

	<form name="deleteEntity" id="formEntity" action="_Programme_delete" method="POST" autocomplete="off" enctype="multipart/form-data">
		
		<h4>Supression d'une programmation de randonnée : <?= $entity ?></h4>
		<DIV style="margin:20px;">
			<p>Attention la supression d'une programmation de randonnée va également supprimer les éléments suivants :</p>
			<ul>
				<li>Les participants enregistrés pour cette randonnée ( au nombre de <?= count($entity->participants) ?>)</li>
				<li>Les animateurs enregistrés pour cette randonnée ( au nombre de <?= count($entity->animateurs) ?>)</li>
				<li>Les reconnaissances associées à cette randonnées</li>
			</ul>
		</DIV>
		<h4>Etes-vous sur de vouloir supprimer cette programmation de randonnée ?</h4>
	
		<DIV class="lineForm">
			<!-- TYPE DE FORMULAIRE -->
			<input type="hidden" name="validForm" value="delete" />
			<!-- IDENTIFIANT DE L'ENTITE -->
			<input type="hidden" name="id" value="<?= $entity->id ?>" />
			<!-- AFFICHAGE DES BOUTONS DU FORMULAIRE -->
			<ul class="Boutons" data-formname="formEntity">
				<li class="submit">OUI</li>
				<li class="cancel">NON</li>
			</ul>
		</DIV>

	</form>
	
</div>
