<?php	
	use lib\DisplayEntity;
	use entities\Role;
	use entities\Etat;
	$lstEntities  = $Model['lstEntities'];
	$recherche    = ( isset($Model['recherche']) ) ? $Model['recherche'] : '';
?>
<H1>Gestion des adhérents</H1>

<p>Bienvenue sur la page de gestion des nouveaux membres. Le tableau ci-dessous contient tous les membres de l'association. 
qui ne sont pas encore des adhérents.</p>

<ul class="Boutons" data-formname="formAddFile">
	<?= DisplayEntity::displayBouton('bouton','Ajouter une fiche','Personne','insert','add',null,"Ajouter une fiche") ?>
	<?= DisplayEntity::displayBouton('bouton','Imprimer le tableau','Personne','lstPrint','print',null,"Imprimer le tableau") ?>
	<?= DisplayEntity::displayBouton('retour','Page précédente') ?>
</ul>

<H2>Liste des personnes à l'essai</H2>

<H3><?= count($lstEntities) ?> futur adhérent(s) ont été trouvé(s) !</H3>

<form class="formfiltre autosubmit" name="filtreMembre" action="_Personne_list&onglet=essais" autocomplete="off" method="POST">
	<h4>Filtres ...</h4>
	<input type="text" name="recherche" placeholder="Chaine à rechercher (Nom, Prénom, Note)" value="<?= $recherche ?>" />
	<input type="hidden" name="validForm" value="formFiltre" />
</form>

<?php include 'views/membre/onglets.php'; ?>

<TABLE width="100%" border="0">

    <TR class="ligneHeader">
		<TH>Nom prénom</TH>
		<TH>Courriel</TH>
		<TH>Telephone</TH>
		<TH colspan="2">Essais</TH>
		<TH>A noter</TH>
		<TH>Actions</TH>
	</TR>
	
<?php
	$bgcolor = false;
	foreach( $lstEntities as $entity) 
	{
		$class = '';
		if ($bgcolor) $class = 'class="tabLigneBg"';
		$bgcolor = !$bgcolor;
?>

    <TR <?=$class ?> >
		<TD><?= strtoupper($entity->nom) ?> <?= $entity->prenom ?></TD>
		<TD><?= $entity->email ?></TD>
		<TD><?= $entity->telephone ?></TD>
		<TD class="alignCenter" style="width:10px;">
			<?= $entity->nbessais ?>
		</TD>
		<TD class="alignCenter" style="width:10px;">
			<UL class="BtnsIco">
				<?= DisplayEntity::displayBouton('bouton','','Personne','inc','add','id='.$entity->id,"Augmenter le nombre d'essais") ?>
			</UL>
		</TD>
		<TD><?= $entity->note ?></TD>
		<TD class="alignCenter">
			<UL class="BtnsIco">
				<?= DisplayEntity::displayBouton('bouton','','Personne','convert','valid','id='.$entity->id,"Convertir en Adhérent") ?>
				<?= DisplayEntity::displayBouton('bouton','','Personne','display','display','id='.$entity->id,"Détail de l'adhérent") ?>
				<?= DisplayEntity::displayBouton('bouton','','Personne','update','edit','id='.$entity->id,"Modification de l'adhérent") ?>
				<?= DisplayEntity::displayBouton('bouton','','Personne','delete','delete','id='.$entity->id,"Suppression de l'adhérent") ?>
			</UL>
		</TD>
	<TR>

<?php
	}
?>
	
</TABLE>
