<?php
	use lib\DisplayEntity;
	use lib\security\Security;
	use entities\Participant;
	use entities\Membre;
	use entities\Personne;
	
	$programme = $Model['entity'];
	$action = "update";
	if ( $programme->id == null ) $action = "insert";
?>

<H1>Gestion des participants</H1>
		
<ul class="Boutons" data-formname="formParticipant">
	<?= DisplayEntity::displayBouton('retour','Page précédente') ?>
</ul>

<DIV class="table form">

	<DIV id="participants" data-pos="<?= count($programme->participants)+1 ?>" data-max="<?= $programme->nbplaces - $programme->inscrits ?>">
		
		<p>La randonnée est passée, vous pouvez ventiler les participants.</p>
		
		<H2>Ventilation des participants</H2>
		<TABLE>
			<TR>
				<TH style="width:30%;">Adhérent</TH>
				<TH style="width:10%;">Licence</TH>
				<TH style="width:24%;">Groupes</TH>
				
				<?php
				foreach ( $programme->parcours as $parcour )
				{
				?>
				
				<TH style="width:12%;"><?= $parcour->id_parcour->nomParcour ?><br />(Diff. <?= $parcour->id_parcour->difficulte ?>)</TH>
				
				<?php
				}
				?>
				
			</TR>

			<?php
			$bgcolor = false;
			foreach ( $programme->participants as $participant )
			{
				if ( $participant->attente == 0 )
				{
					$class = '';
					if ($bgcolor) $class = 'class="tabLigneBg"';
					$bgcolor = !$bgcolor;
			?>
			
			<TR <?= $class ?> id="participant_<?= $participant->id ?>" style="width:280px; padding-right: 25px">
				<TD><?= $participant ?> <?= ( $participant->attente == 1 ) ? "(En attente)" : "" ?></TD>
				<TD class="alignCenter"><?= ( $participant->id_membre != null ) ? $participant->id_membre->licence : "" ?></TD> <!-- Numéro de licence -->
				<TD><?= ( $participant->id_membre != null ) ? $participant->id_membre->getAttribut('roles')->displayInline : "" ?></TD> <!-- Groupes -->
				
				<?php
					foreach ( $programme->parcours as $parcour )
					{
						$parcours = $participant->parcours;
				?>
				
				<TD class="alignCenter">
					<INPUT type="checkbox" class="ventile" data-url="_Programme_ventile&id=<?= $programme->id ?>&id_participant=<?= $participant->id ?>&id_parcour=<?= $parcour->id_parcour->id ?>" id="parcour_<?= $participant->id ?>_<?= $parcour->id_parcour->id ?>" name="parcour_<?= $participant->id ?>[]" value="<?= $parcour->id_parcour->id ?>" <?= ( isset($parcours[$parcour->id_parcour->id]) ) ? 'CHECKED' : '' ?> />
				</TD>
				
				<?php
					}
				?>
				
			</TR>

			<?php
				}
			}
			?>
			
		</TABLE>

	</DIV>
		
</DIV>
