<?php
	use lib\DisplayEntity;
	use lib\security\Security;
	use entities\Participant;
	use entities\Membre;
	use entities\Personne;
	
	$programme = $Model['entity'];
	$action = "update";
	if ( $programme->id == null ) $action = "insert";
?>

<H1>Gestion des participants</H1>
		
<ul class="Boutons" data-formname="formParticipant">
	<?php
		if ( $programme->isProprio() || Security::isAdmin() || Security::isCoordinateur() ) 
		{
			echo DisplayEntity::displayBouton('bouton','Mails','Mail','formMailing','mail','idProgramme='.$programme->id,"Envois de courriels aux participants");
			echo DisplayEntity::displayBouton('bouton','Imprimer la liste','Edition','printParticipants','print','idProgramme='.$programme->id,"Imprimer la liste");
		}
		echo DisplayEntity::displayBouton('retour','Page précédente');
	?>
</ul>

<DIV class="table form">

	<H3> <?= $programme->inscrits ?> Participants sur <?= $programme->nbplaces ?> places prévues <?= ( $programme->enAttente > 0 ) ? "(".$programme->enAttente." personnes en attente)" : "" ?></H3>

	<?php
		if ( Security::isAdmin() || Security::isCoordinateur() || $programme->isResponsable() )
		{
	?>
	
	<H2>
		Ajouter un participant
		<UL class="tinyBoutons">
			<?= DisplayEntity::displayBouton('ajaxOpen','Nouveau','Programme','newParticipant','add','id='.$programme->id,"Nouveau participant",null,null,$programme) ?>
		</UL>
	</H2>

	<DIV>
		<FORM id="formParticipant" name="formParticipant" class="form" action="_Programme_addParticipant" method="POST" autocomplete="off" enctype="multipart/form-data">
			<SPAN>
				<INPUT type="text" id="nomparticipant" name="nomparticipant" autocomplete="off" list="lstMembres" value="" />
				<INPUT type="hidden" id="id" name="id" value="<?= $programme->id ?>" />
				<UL class="tinyBoutons" data-formname="formParticipant">
					<?= DisplayEntity::displayBouton('submit','Ajouter') ?>
				</UL>
			</SPAN>
		</FORM>
	</DIV>

	<?php
		}
	?>

	<DIV id="participants" data-pos="<?= count($programme->participants)+1 ?>" data-max="<?= $programme->nbplaces -$programme->inscrits ?>">

		<H2>liste des participants</H2>
		<TABLE>
			<?php
				$Model['boutons'] = true;
				$Model['ventile'] = true;
				$Model['attente'] = 0;
				include "views/participant/displayCellTitle.php" ; 
			?>
			<?= $programme->afficheParticipants(0,true,true); ?>
		</TABLE>

		<H2>liste d'attente</H2>
		<TABLE>
			<?php
				$Model['boutons'] = true;
				$Model['ventile'] = true;
				$Model['attente'] = 1;
				include "views/participant/displayCellTitle.php" ; 
			?>
			<?= $programme->afficheParticipants(1,false,true); ?>
		</TABLE>
	</DIV>
		
</DIV>

<DATALIST id="lstMembres">
	<?= Membre::selectListForm('nom,prenom','id_etat IN (1,2)','nom,prenom') ?>
	<?= Personne::selectListForm('nom,prenom',null,'nom,prenom') ?>
</DATALIST>
