<?php	
	use lib\DisplayEntity;
	use entities\Role;
	use entities\Etat;
	$lstEntities  = $Model['lstEntities'];
	$recherche    = ( isset($Model['recherche']) ) ? $Model['recherche'] : '';
	$id_etat      = ( isset($Model['id_etat']) ) ? $Model['id_etat'] : 0;
	$id_role      = ( isset($Model['id_role']) ) ? $Model['id_role'] : 0;
	$actif        = ( isset($Model['actif']) ) ? 'CHECKED' : '' ;
	$datecreation = ( isset($Model['datecreation']) ) ? $Model['datecreation'] : '';
?>
<H1>Gestion des adhérents</H1>

<p>Bienvenue sur la page de gestion des Adhérents. Le tableau ci-dessous contient tous les adhérents de l'association. 
Vous avez la possibilité de les trier ou d'effectuer une recherche.</p>

<ul class="Boutons" data-formname="formAddFile">
	<?= DisplayEntity::displayBouton('bouton','Ajouter une fiche','Membre','insert','add',null,"Ajouter une fiche") ?>
	<?= DisplayEntity::displayBouton('bouton','Liste simplifiée','Edition','printAdherents','print',null,"Imprimer la liste simplifié des adhérents") ?>
	<?= DisplayEntity::displayBouton('retour','Page précédente') ?>
</ul>

<H2>Liste des adhérents</H2>

<H3><?= count($lstEntities) ?> adhérent(s) ont été trouvé(s) !</H3>

<form class="formfiltre autosubmit" name="filtreMembre" action="_Membre_list" method="POST" autocomplete="off">
	<h4>Filtres ...</h4>
	<input type="text" name="recherche" placeholder="Chaine à rechercher (Nom, Prénom, Licence, Note)" value="<?= $recherche ?>" />
	<?= Role::displayList($id_role) ?>
	<?= Etat::displayList($id_etat) ?>
	<label>Actif : </label><input type="checkbox" name="actif" value="1" <?= $actif ?> />
	<br />
	<h4></h4>
	<label>Adhérent inscript après le ... </label><input type="text" class="date" name="datecreation" placeholder="jj/mm/yyyy" value="<?= $datecreation ?>" />
	<input type="hidden" name="validForm" value="formFiltre" />
</form>

<?php include 'views/membre/onglets.php'; ?>

<TABLE width="100%" border="0">

    <TR class="ligneHeader">
		<TH>Nom prénom</TH>
		<TH>Licence</TH>
		<TH>Groupe</TH>
		<TH>Statut</TH>
		<TH>Activité</TH>
		<TH>A noter</TH>
		<TH>Actions</TH>
	</TR>
	
<?php
	$bgcolor = false;
	foreach( $lstEntities as $entity) 
	{
		$class = '';
		if ($bgcolor) $class = 'class="tabLigneBg"';
		$bgcolor = !$bgcolor;
		$actif = '';
		if ( $entity->actif == 1 ) $actif = '<IMG SRC="web/images/check.png" />';
?>

    <TR <?=$class ?> >
		<TD><?= strtoupper($entity->nom) ?> <?= $entity->prenom ?></TD>
		<TD><?= $entity->licence ?></TD>
		<TD><?= $entity->getAttribut('roles')->affiche() ?></TD>
		<TD><?= $entity->etat ?></TD>
		<TD class="alignCenter"><?= $actif ?></TD>
		<TD><?= $entity->note ?></TD>
		<TD class="alignCenter">
			<UL class="BtnsIco">
				<?php
					if ( $entity->etat->id != 1 ) {
						echo DisplayEntity::displayBouton('bouton','','Cheque','renouveler','valid','id_membre='.$entity->id,"Renouvellement de l'inscription");
					}
				?>
				<?= DisplayEntity::displayBouton('bouton','','Membre','display','display','id='.$entity->id,"Détail de l'adhérent") ?>
				<?= DisplayEntity::displayBouton('bouton','','Membre','update','edit','id='.$entity->id,"Modification de l'adhérent",null,null,$entity) ?>
				<?= DisplayEntity::displayBouton('bouton','','Membre','delete','delete','id='.$entity->id,"Suppression de l'adhérent") ?>
			</UL>
		</TD>
	<TR>

<?php
	}
?>
	
</TABLE>
