<?php
	use lib\DisplayEntity;
	use lib\security\Security;
	use entities\Licence;
	use entities\TypeAnimateur;
	use entities\Etat;
	use entities\Role_Membre;
	use entities\Membre_Fichier;
	
	$membre = $Model['entity'];
	$action = "update";
	if ( $membre->id == null ) $action = "insert";
?>

<H1>Fiche Adhérent</H1>
	
<ul class="Boutons">
	<?= DisplayEntity::displayBouton('retour','Retour') ?>
</ul>

<form id="formMembre" name="formMembre" class="form" action="_Membre_<?= $action ?>" method="POST" autocomplete="off" enctype="multipart/form-data">

	<DIV class="table form">

		<?php
			if ( Security::isAdmin() || Security::isGestionnaire() ) 
			{
		?>
			<H2>Informations personnelles</H2>
			
			<DIV>
				<LABEL>Identifiant de connexion : </LABEL>
				<SPAN><input type="text" id="login" name="login" placeholder="Login" value="<?= $membre->login ?>" /></SPAN>
			</DIV>
			
			<?php
				if ( $action == "update" ) 
				{
			?>
				<DIV>
					<LABEL>Mot de passe : </LABEL>
					<SPAN id="password">
						<UL class="tinyBoutons">
							<?= DisplayEntity::displayBouton('ajaxOpen','Modifier','Membre','changePwd','edit','id='.$membre->id,"Modification du mot de passe",null,null,$membre) ?>
						</UL>
					</SPAN>
				</DIV>
			<?php
				}
			?>
			<DIV>
				<LABEL>Numéro de licence : </LABEL>
				<SPAN><input type="text" id="licence" name="licence" placeholder="licence" value="<?= $membre->licence ?>" REQUIRED /></SPAN>
			</DIV>
			<DIV>
				<LABEL>Type de licence : </LABEL>
				<SPAN>
					<?= Licence::displayList((($membre->id_licence != null) ? $membre->id_licence->id : 0)) ?>
				</SPAN>
			</DIV>
			<DIV>
				<LABEL>Date d'attribution de la licence : </LABEL>
				<SPAN><input type="text" class="date" id="datelicence" name="datelicence" placeholder="datelicence" value="<?= $membre->getAttribut('datelicence')->date ?>" /></SPAN>
			</DIV>
			<DIV>
				<LABEL>Type d'animateur : </LABEL>
				<SPAN>
					<?= TypeAnimateur::displayList((($membre->id_typeanimateur != null) ? $membre->id_typeanimateur->id : 0)) ?>
				</SPAN>
			</DIV>
			<DIV>
				<LABEL>
					Brevets : 	
					<UL class="tinyBoutons">
						<LI class="ajaxAdd add" data-url="_Brevet_add" data-idcible="brevets" >Ajouter</LI>
					</UL>
					<input type="hidden" name="brevets" value="true" />
				</LABEL>
				<SPAN id="brevets" data-pos="<?= count($membre->brevets) ?>">
					<?= $membre->displayBrevets() ?> 
				</SPAN>
			</DIV>
			<DIV>
				<LABEL>
					Certificats : 	
					<UL class="tinyBoutons">
						<LI class="ajaxAdd add" data-url="_Certificat_add" data-idcible="certifs" >Ajouter</LI>
					</UL>
					<input type="hidden" name="certifs" value="true" />
				</LABEL>
				<SPAN id="certifs" data-pos="<?= count($membre->certifs) ?>">
					<?= $membre->displayCertificats() ?> 
				</SPAN>
			</DIV>
			<DIV>
				<LABEL>Autre club : </LABEL>
				<SPAN><input type="text" id="autreclub" name="autreclub" placeholder="autreclub" value="<?= $membre->autreclub ?>" /></SPAN>
			</DIV>
		<?php
			}
		?>

		<H2>Etat civil</H2>

		<DIV>
			<LABEL>Sexe : </LABEL>
			<SPAN>
				<input type="radio" id="sexe" name="sexe" value="M" <?= ($membre->sexe != 'F') ? "CHECKED" : "" ?> /> : Homme<br />
				<input type="radio" id="sexe" name="sexe" value="F" <?= ($membre->sexe == 'F') ? "CHECKED" : "" ?> /> : Femme
			</SPAN>
		</DIV>
		<DIV>
			<LABEL>Nom : </LABEL>
			<SPAN><input type="text" id="nom" name="nom" placeholder="nom" value="<?= $membre->nom ?>" REQUIRED /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Prenom : </LABEL>
			<SPAN><input type="text" id="prenom" name="prenom" placeholder="prenom" value="<?= $membre->prenom ?>" REQUIRED /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Nom de jeune fille : </LABEL>
			<SPAN><input type="text" id="nomjeunefille" name="nomjeunefille" placeholder="nomjeunefille" value="<?= $membre->nomjeunefille ?>" /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Date de naissance : </LABEL>
			<SPAN><input type="text" class="date" id="datenaissance" name="datenaissance" placeholder="datenaissance" value="<?= $membre->getAttribut('datenaissance')->date ?>" /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Lieu de naissance : </LABEL>
			<SPAN><input type="text" id="lieunaissance" name="lieunaissance" placeholder="lieunaissance" value="<?= $membre->lieunaissance ?>" /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Photo : </LABEL>
			<SPAN>
				<input type="hidden" name="fichiers" value="true" />
				<?= $membre->getAttribut('fichiers')->displayCell($membre->id,true,true,'views/membre/displayPhoto.php',true) ?>
			</SPAN>
		</DIV>

		<H2>Coordonnées de contact</H2>

		<DIV>
			<LABEL>Courriel : </LABEL>
			<SPAN><input type="text" class="mail" id="mail" name="mail" placeholder="mail" value="<?= $membre->mail ?>" /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Téléphone : </LABEL>
			<SPAN><input type="text" class="tel" id="telephone" name="telephone" placeholder="telephone" value="<?= $membre->telephone ?>" /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Portable : </LABEL>
			<SPAN><input type="text" class="tel" id="portable" name="portable" placeholder="portable" value="<?= $membre->portable ?>" /></SPAN>
		</DIV>
		<DIV>
			<LABEL>
				Adresses : 	
				<UL class="tinyBoutons">
					<LI class="ajaxAdd add" data-url="_Adresse_add" data-idcible="adresses" >Ajouter</LI>
				</UL>
				<input type="hidden" name="adresses" value="true" />
			</LABEL>
			<SPAN id="adresses" data-pos="<?= count($membre->adresses)+1 ?>">
				<?= $membre->displayAdresses() ?> 
			</SPAN>
		</DIV>
		<DIV>
			<LABEL>
				Personnes à contacter : 
				<UL class="tinyBoutons">
					<LI class="ajaxAdd add" data-url="_Prevenir_add" data-idcible="contacts" >Ajouter</LI>
				</UL>
				<input type="hidden" name="contacts" value="true" />
			</LABEL>
			<SPAN id="contacts" data-pos="<?= count($membre->contacts)+1 ?>">
				<?= $membre->displayContacts() ?>
			</SPAN>
		</DIV>

		<H2>Informations complémentaires</H2>

		<DIV>
			<LABEL>Actif : </LABEL>
			<SPAN>
				OUI <input type="radio" id="actif" name="actif" value="1" <?= ($membre->actif == 1) ? "CHECKED" : "" ?> />
				NON <input type="radio" id="actif" name="actif" value="0" <?= ($membre->actif == 0) ? "CHECKED" : "" ?> />
			</SPAN>
		</DIV>
		<DIV>
			<LABEL>Activité actuelle : </LABEL>
			<SPAN><input type="text" id="activiteactu" name="activiteactu" placeholder="activiteactu" value="<?= $membre->activiteactu ?>" /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Activité antérieure : </LABEL>
			<SPAN><input type="text" id="activiteante" name="activiteante" placeholder="activiteante" value="<?= $membre->activiteante ?>" /></SPAN>
		</DIV>
		
		<?php
			if ( Security::isAdmin() || Security::isGestionnaire() ) 
			{
		?>
		
		<DIV>
			<LABEL>
				Etat : 	
			</LABEL>
			<SPAN>
				<?= Etat::displayList((($membre->id_etat != null) ? $membre->id_etat->id : 8),true) ?>
			</SPAN>
		</DIV>
		<DIV>
			<LABEL>Rôles : </LABEL>
			<SPAN id="roles">
				<?= Role_Membre::displayListForm($membre->roles) ?> 
				<input type="hidden" name="roles" value="true" />
			</SPAN>
		</DIV>
		<DIV>
			<LABEL>
				Paiements : 
				<UL class="tinyBoutons">
					<LI class="ajaxAdd add" data-url="_Cheque_add&nomCheque=<?= $membre ?>" data-idcible="cheques" >Ajouter</LI>
				</UL>
				<input type="hidden" name="cheques" value="true" />
			</LABEL>
			<SPAN id="cheques" data-pos="<?= count($membre->cheques)+1 ?>">
				<?= $membre->displayCheques() ?> 
			</SPAN>
		</DIV>
		<DIV>
			<LABEL>Note : </LABEL>
			<SPAN><TEXTAREA id="note" name="note"><?= $membre->note ?></TEXTAREA></SPAN>
		</DIV>
		<DIV>
			<LABEL>Commentaire : </LABEL>
			<SPAN><TEXTAREA id="commentaire" name="commentaire"><?= $membre->commentaire ?></TEXTAREA></SPAN>
		</DIV>
		
		<?php
			}
		?>
		
	</DIV>	

	<input type="hidden" name="validForm" value="formMembre" />
	<input type="hidden" name="id" value="<?= $membre->id ?>" />
	
	<?php
		if ( isset($Model['entityDelete']) ) {
	?>
		<input type="hidden" name="id_personne" value="<?= $Model['entityDelete']->id ?>" />
	<?php
		}
	?>
		
	<ul class="Boutons" data-formname="formMembre">
		<li class="submit">Valider</li>
		<li class="cancel">Annuler</li>
	</ul>
	
</form>

