<?php	
	use lib\DBConnexion;
	use lib\Constantes;
	use lib\Labels;
	use lib\attributs\DateHeure;
	$lstProgs  = $Model['lstProgs'];
	$programme = current($lstProgs);
	$lstInfos  = $Model['lstInfos'];
	$phrase    = '';
	if ( !empty($Model['phrase']) ) $phrase = current($Model['phrase']);
	$enprojet = "web/images/en_projet.png";
?>

<STYLE type="text/css">
<!--
BODY * {
	font-family: Arial, Ms;
}
H1 {
	font-size: 14pt;
	font-weight: bold;
	color: #794a13;
	padding: 0; 
	margin: 0 0 15px 0;
}
H2 {
	font-size: 14pt;
	font-weight: bold;
	color: #9e4e46;
	text-align: right;
	padding: 0; 
	margin: 0 0 5px 0;
}
DIV.h3 {
	display: block;
	font-size: 15pt;
	border: solid 1px #9e4e46;
	text-align: center;
	padding: 5px; 
	margin: 10px 0;
}
H4 {
	font-size: 8pt;
	color: #0000FF;
	text-align: center;
	padding: 0; 
	margin: 10px 0 10px 0;
}
H5 {
	font-size: 10pt;
	font-variant: small-caps;
	text-decoration: underline;
	padding: 0; 
	margin: 15px 0 10px 0;
}
P {
	font-size: 7pt;
	line-height: 8pt;
	padding: 0; 
	margin: 0;
}
.entete P {
	font-size: 9pt;
	line-height: 9pt;
}
TABLE {
	border-collapse: collapse;
	padding: 0px; margin: 0px;
}
TR {
	padding: 0px; margin: 0px;
}
TD {
	vertical-align: middle;
	font-weight: bold;
	font-size: 7pt;
	line-height: 8pt;
	padding: 0px; margin: 0px;
}
.borderTop {
	border-top: solid 1px #9e4e46;
}
.borderBottom {
	border-bottom: solid 1px #9e4e46;
}
TD TD {
	vertical-align: top;
}
.titre TD {
	font-size: 8pt;
	height: 12pt;
	vertical-align: middle;
}
.inscription TD {
	line-height: 9pt;
}
.particulatite TD {
	line-height: 9pt;
}
.centrer {
	text-align: center;
}
.rouge {
	color: #FF0000;
}
.information, .information * {
	font-size: 9pt;
	line-height: 10pt;
}
-->
</STYLE>

<page backleft="5mm" backright="5mm" backtop="5mm" backbottom="5mm">

	<?php
		if ( !isset($Model['edit']) ) {
	?>
			<DIV style="position:absolute;top:0mm;left:30mm;width:150mm;"><IMG src="<?= $enprojet ?>" style="width:100%;" /></DIV>
	<?php
		}
	?>
	<table class="entete" style="width:100%;">
		<tr>
			<td style="width:50%;">
				<H1>LES RANDONNEURS SANARYENS</H1>
				<b>
					<p><?= Constantes::getParametre('rando_adresse')->valeur ?></p>
					<p>Tél : <?= Constantes::getParametre('rando_tel')->valeur ?></p>
				</b>
				<p>Email : <?= Constantes::getParametre('mail_adherent')->valeur ?></p>
				<p>Site : <?= Constantes::getParametre('rando_site')->valeur ?></p>
				<TABLE>
					<tr>
						<TD style="vertical-align:top;text-decoration:underline;">
							<p>Permanences :&nbsp;</p>
						</TD>
						<TD style="vertical-align:top;">
							<p>septembre/décembre : 9h30-11h00, jeudi et samedi</p>
							<p>janvier/juin : 9h30-11h00, samedi</p>
						</TD>
					</tr>
				</TABLE>
			</td>
			<td style="width:50%; text-align:center;">
				<IMG src="web/images/Logo.png" style="width:80px; margin:5px;" />
				<H2>PROGRAMME DE <?= mb_strtoupper (DateHeure::getLibelleMois(intval($Model['mois'])), 'UTF-8') ?> <?= $Model['annee'] ?></H2>
			</td>
		</tr>
	</table>
	
	<DIV class="borderTop borderBottom" style="padding: 2px 0px 3px 0px; margin: 5px 0px;">
		<table style="width:100%; margin:0px; padding:0px;">
			<tr>
				<td style="width:50%;vertical-align:top;padding:5px;">
					<p>Les inscriptions sont prises de 9H00 à 12H00 et de 18H00 à 20H00.</p>
					<p>Les messages laissés sur répondeur ne sont pas pris en compte.</p>
					<p>Une demi-heure avant l'heure de départ, l'animateur responsable de la 
					randonnée peut être joint au <?= Constantes::getParametre('rando_portable')->valeur ?>.</p>
					<p>Les chaussures de randonnée sont obligatoires.</p>
				</td>
				<td style="width:50%;vertical-align:top;padding:5px;">
					<p>
						<?= Labels::get("PRINT-PROG-RANDO-ANNUL") ?>
					</p>
				</td>
			</tr>
		</table>
	</DIV>

	<H4><?= $phrase ?></H4>

	<?php
	foreach ( $lstProgs as $prog ) 
	{
		$telinscription = $prog->telinscription;
		if ( $prog->id_inscription != null && empty($telinscription) ) {
			$telinscription = $prog->id_inscription->telephone;
		}
	?>
	<nobreak>
	<DIV class="borderBottom" style="padding: 2px 0px 3px 0px; margin: 0px;">
		<table style="width:100%;">
		
			<TR class="titre">
				<td style="width:100%" colspan="7">
					<table style="width:100%">
						<tr>
							<td style="width:20%;font-size:9pt;"><?= $prog->getAttribut('datedepart')->dateStr ?></td>
							<td style="width:35%;"><?= $prog->getAttribut('heuredepart')->heureMin ?> - <?= mb_strtoupper ($prog->depart_lieu, 'UTF-8') ?> - <?= mb_strtoupper ($prog->communedepart, 'UTF-8') ?><?= ( $prog->vehicule != null ) ? ' EN '.mb_strtoupper($prog->vehicule, 'UTF-8') : '' ?></td>
							<td style="width:45%;"><?= mb_strtoupper ($prog->randonnee->lieu, 'UTF-8') ?> - <?= mb_strtoupper ($prog->randonnee->commune, 'UTF-8') ?> (<?= $prog->randonnee->departement ?>)</td>
						</tr>
					</table>
				</td>
			</TR>
		
			<?php
			foreach ( $prog->parcours as $progparcour ) 
			{
				$parcour = $progparcour->parcour;
			?>
																																					
				<TR class="parcour">
					<td style="width:10%;"><?= $parcour->displayDifficulte() ?></td>

					<td style="width:7%;"><?= $parcour->longueur ?> km</td>
					<td style="width:7%;">+<?= $parcour->deniveleup ?> m</td>
					<td style="width:7%;">-<?= $parcour->deniveledown ?> m</td>
					<td style="width:7%;"><?= $parcour->getAttribut('duree')->heureMin ?></td>
					<td style="width:17%;">IGN <?= $parcour->ign ?></td>

					<td style="width:45%;"><?= $prog->parcourAnimateurs($parcour->id) ?></td>
				</TR>
				
				<?php if ( $parcour->remarques != null ) { ?>
					<TR>
						<td style="width:100%" colspan="7">
							<table>
								<tr>
									<td style="width:12%;font-weight:bold;">Particularités : </td>
									<td style="width:88%;"><?= str_replace('[','<b class="rouge">',str_replace(']','</b>',$parcour->remarques)) ?></td>
								</tr>
							</table>
						</td>
					</TR>
				<?php } ?>	

			<?php
			}
			?>
			
			<?php if ( $prog->note != null ) { ?>
			<TR>
				<td style="width:100%" colspan="7">
					<table style="width:100%">
						<tr>
							<td style="width:12%;font-weight:bold;">Notes : </td>
							<td style="width:88%;"><?= str_replace('[','<b class="rouge">',str_replace(']','</b>',$prog->note)) ?></td>
						</tr>
					</table>
				</td>
			</TR>
			<?php } ?>	
			<?php if ( $prog->inscription != null ) { ?>
			<TR>
				<td class="inscription" style="width:100%" colspan="7">
					<table style="width:100%">
						<tr>
							<td style="width:12%;font-weight:bold;">Inscriptions : </td>
							<td style="width:88%;"><?= $prog->inscription ?> au <?= $telinscription ?> à partir du <?= $prog->getAttribut('dateinscription')->dateStr ?></td>
						</tr>
					</table>
				</td>
			</TR>
			<?php } ?>
			
		</table>
	</DIV>
	</nobreak>
		
	<?php
	}
	?>
	
	<nobreak>
	<br />
	<DIV class="h3">INFORMATIONS <?= mb_strtoupper (DateHeure::getLibelleMois(intval($Model['mois'])), 'UTF-8') ?> <?= $Model['annee'] ?></DIV>

	<?php
		foreach ( $lstInfos as $info ) 
		{
	?>

	<DIV>
		<H5><?= DBConnexion::SQLDecode($info->titre) ?></H5>
		<DIV class="information">
			<?= $info->txtinformation ?>
		</DIV>
	</DIV>
	</nobreak>
	<nobreak>

	<?php
		}
	?>
	<br><br>
	<DIV class="centrer">
		<IMG style="width:100mm;" src="web/images/resume_difficulte.png" />
	</DIV>
	</nobreak>

</page>
