<?php
	use lib\DisplayEntity;
	use lib\security\Security;
	use entities\Programme;
	use entities\Reconnaissance;
	$lstProgrammes = $Model['lstEntities'];
	$lstAdherents  = $Model['lstAdherents'];
?>

<SCRIPT type="text/javascript">
	function showElmt() {
		if ( $("#typeMailing").find("OPTION:SELECTED").val() == "partsRando" ) {
			$("#lstAdeherents").hide();
			$("#lstProgrammes").show();
		}
		else if ( $("#typeMailing").find("OPTION:SELECTED").val() == "adherents" ) {
			$("#lstProgrammes").hide();
			$("#lstAdeherents").show();
		}
		else {
			$("#lstAdeherents").hide();
			$("#lstProgrammes").hide();
		}
	}	
</SCRIPT>

<H1>Contacter des adhérents</H1>
	
<ul class="Boutons">
	<?= DisplayEntity::displayBouton('retour','Retour') ?>
</ul>

<form id="formMailin" name="formMailin" class="form" action="_Mail_sendMailing" method="POST" autocomplete="off" enctype="multipart/form-data">

	<DIV class="table form">

		<H2>Envoi de courriel</H2>
		
		<?php
			if ( !isset($Model['idProgramme']) &&  !isset($Model['idReco']) ) 
			{
		?>
		
		<DIV>
			<LABEL>Type d'envoi : </LABEL>
			<SPAN>
				<SELECT id="typeMailing" name="typeMailing" onChange="showElmt();">
					<OPTION value="all">A tous les adhérents</OPTION>
					<OPTION value="animateurs">Aux animateurs</OPTION>
					<?php
						if ( Security::isBureau() || Security::isCA() || Security::isChargeDeMission() ||Security::isCoordinateur() || Security::isAdmin() ) 
						{
					?>
					<OPTION value="CA">Aux membres du CA</OPTION>
					<OPTION value="adherents">A une liste d'adhérents</OPTION>
					<OPTION value="partsRando">Aux participants d'une randonnée programmée</OPTION> 
					<?php
						}
					?>
				</SELECT>
			</SPAN>
		</DIV>
		<DIV id="lstProgrammes" style="display:none;">
			<LABEL>Randonnées programmées : </LABEL>
			<SPAN>
				<SELECT id="id_programme" name="id_programme" style="width:450px;">
					<?php
						foreach ($lstProgrammes as $programme) 
						{
					?>
						<OPTION value="<?= $programme->id ?>"><?= $programme ?></OPTION>
					<?php
						}
					?>
				</SELECT>
			</SPAN>
			<SPAN>
				Selectionnez la randonnées pour envoyer les courriels à ses participants.
			</SPAN>
		</DIV>	
		<DIV id="lstAdeherents" style="display:none;">
			<LABEL>Adhérents : </LABEL>
			<SPAN>
				<DIV style="display:block;border:solid 1px #CCC;padding:5px;width:300px;height:140px;overflow-y:scroll;overflow-x:none;">
					<?php
						foreach ($lstAdherents as $membre) 
						{
					?>
						<DIV><INPUT type="checkbox" name="adherents[]" value="<?= $membre->id ?>" /> <?= $membre ?></DIV>
					<?php
						}
					?>
				</DIV>
			</SPAN>
			<SPAN>
				Sélectionnez les adhérents à contacter.
			</SPAN>
		</DIV>	
		<?php
			}
			elseif ( isset($Model['idProgramme']) )
			{
		?>
			<INPUT type="hidden" name="typeMailing" value="partsRando" />
			<INPUT type="hidden" name="id_programme" value="<?= $Model['idProgramme'] ?>" />
		<?php
			}
			elseif ( isset($Model['idReco']) )
			{
		?>
			<INPUT type="hidden" name="typeMailing" value="partsReco" />
			<INPUT type="hidden" name="id_reco" value="<?= $Model['idReco'] ?>" />
		<?php
			}
		?>
		
		<DIV>
			<LABEL>Objet de l'envoi : </LABEL>
			<SPAN><input type="text" id="objet" name="objet" placeholder="Objet" value="" /></SPAN>
		</DIV>		
		<DIV>
			<LABEL>Message : </LABEL>
			<SPAN><TEXTAREA id="message" name="message" style="width:620px;height:300px;"></TEXTAREA></SPAN>
		</DIV>
		<DIV>
			<LABEL>
				Piece jointe : 
				<UL class="tinyBoutons">
					<LI class="ajaxAdd add" data-url="_Mail_addfile" data-idcible="fichiers" >Ajouter</LI>
				</UL>
			</LABEL>
			<SPAN id="fichiers" data-pos="1">
			</SPAN>
			<SPAN>
				Allez chercher le fichier à envoyer sur votre disque dur.
			</SPAN>
		</DIV>
		
		<?php
			if ( isset($Model['idProgramme']) ) 
			{
		?>
			<DIV>
				<LABEL>Participants sans courriel : </LABEL>
				<SPAN>
					<UL>
					<?php
						
						$programme = new Programme( intval($Model['idProgramme']) );
						$lst = array();
						foreach( $programme->animateurs as $animateur ) {
							if ( $animateur->id_animateur->mail == null ) {
								echo '<LI>'.$animateur.'</LI>';
							}
						}
						foreach( $programme->participants as $participant ) {
							if ( $participant->id_membre != null && $participant->id_membre->mail == null ) {
								echo '<LI>'.$participant->id_membre.'</LI>';
							}
							if ( $participant->id_personne != null && $participant->id_personne->mail == null ) {
								echo '<LI>'.$participant->id_personne.'</LI>';
							}
						}
					?>
					</UL>
				</SPAN>
			</DIV>
		<?php				
			}
			if ( isset($Model['idReco']) ) 
			{
		?>
			<DIV>
				<LABEL>Participants sans courriel : </LABEL>
				<SPAN>
					<UL>
					<?php
						
						$programme = new Reconnaissance( intval($Model['idReco']) );
						$lst = array();
						foreach( $programme->participants as $participant ) {
							if ( $participant->id_participant != null && $participant->id_participant->mail == null ) {
								echo '<LI>'.$participant->id_participant.'</LI>';
							}
						}
					?>
					</UL>
				</SPAN>
			</DIV>
		<?php				
			}
		?>
		
	</DIV>	

	<input type="hidden" name="validForm" value="formMailin" />
		
	<ul class="Boutons" data-formname="formMailin">
		<li class="submit">Envoyer</li>
		<li class="cancel">Annuler</li>
	</ul>
	
</form>
