<?php
	/**
	* Vue gérant l'affichage d'un formulaire générique d'insertion et de mise à jour d'une Enitée
	*
	* @copyright  Copyright (c) 2015 DYNAVEO, COnseils et Services en Informatique
	* @author Patrice Cuissard
	* @version    1.0
	*/
	
	use lib\DisplayEntity;

	$entity = $Model['entity'];					// On récupère l'entité dans le tableau associatif Global $Model
	$typeForm = "insert";						// par defaut il s'agit d'un formulaire d'insertion.
	$libelle = "Création d'une Entité";
	if ( $entity->id != null ) {
		$typeForm = "update";
		$libelle = "Mise à jour d'une Entité";
	}
?>


<H1><?= $libelle ?></H1>
		
<ul class="Boutons">
	<?= DisplayEntity::displayBouton('retour','Retour') ?>
</ul>
		
<form name="<?= $typeForm ?>Entity" class="form" id="formEntity" action="_<?= $_GET['model'] ?>_<?= $typeForm ?>" method="POST" autocomplete="off" enctype="multipart/form-data">
	<DIV class="table form">
	
<?php
	// Parcours de la liste des attributs décrivants l'entité
	foreach( $entity->getAttributs() as $attName => $attribut )
	{
		if ( $attribut->type() != 'liste' && $attribut->type() != 'key' ) 
		{
			// Affichage d'un ligne de formulaire pour l'attribut.
			DisplayEntity::displayLineForm($attName,$attribut,$entity);
		}
	}
?>
	</DIV>	

	<!-- TYPE DE FORMULAIRE -->
	<input type="hidden" name="validForm" value="<?= $typeForm ?>" />
	
	<!-- IDENTIFIANT DE L'ENTITE -->
	<?= DisplayEntity::displayInput($entity::$COL_ID,'hidden',null,null,$entity->id,null) ?>
		
	<!-- AFFICHAGE DES BOUTONS DU FORMULAIRE -->
	<ul class="Boutons" data-formname="formEntity">
		<li class="submit">Valider</li>
		<li class="cancel">Annuler</li>
	</ul>

</form>

