<?php
	/**
	* Vue gérant l'affichage d'un formulaire générique d'insertion et de mise à jour d'une Enitée
	*
	* @copyright  Copyright (c) 2015 DYNAVEO, COnseils et Services en Informatique
	* @author Patrice Cuissard
	* @version    1.0
	*/
	
	use lib\DisplayEntity;

	$entity = $Model['entity'];					// On récupère l'entité dans le tableau associatif Global $Model
	$typeForm = "insert";						// par defaut il s'agit d'un formulaire d'insertion.
	$libelle = $Model['titre_page'];
	if ( $entity->id != null ) {
		$typeForm = "update";
	}
?>

<h2><?= $libelle ?></h2>
		
<ul class="Boutons">
	<?= DisplayEntity::displayBouton('retour','Retour') ?>
</ul>

<DIV class="table form">
	
<?php
	// Parcours de la liste des attributs décrivants l'entité
	foreach( $entity->getAttributs() as $attName => $attribut )
	{
		?>
		<DIV 
		class="lineForm">
			<LABEL><?= $attribut->libelle ?> : </LABEL> 
			<SPAN>
<?php
		if ( $attribut->type() == 'file' ) 
		{
			$fichier = $entity->titre;
			$mime = $attribut->mime;
			$type = substr($mime,0,strpos($mime,'/'));
			
			switch ($type) {
				case 'image' :
					?>
					<IMG src="<?= $fichier ?>" alt="<?= $attName ?>" title="<?= $attName ?>" width="200px" />
					<?php
					break;
				case 'audio' :
					?>			
					<audio controls>
						<source src="<?= $fichier ?>" type="<?= $mime ?>">
						<a href="<?= $fichier ?>" title="<?= $attName ?>" target="<?= $attName ?>"><?= $attName ?></a>
					</video> 
					<?php
					break;
				case 'video' :
					?>			
					<video width="160" height="120" controls>
						<source src="<?= $fichier ?>" type="<?= $mime ?>">
						<a href="<?= $fichier ?>" title="<?= $attName ?>" target="<?= $attName ?>"><?= $attName ?></a>
					</video> 
					<?php
					break;
				default :
					?>			
					<a href="<?= $fichier ?>" title="<?= $attName ?>" target="<?= $attName ?>"><?= $attName ?></a>
					<?php
					break;
			}
		}
		else {
			echo $entity->affiche($attName);
		}

?>
			</SPAN>
		</DIV>
		<?php
	}
?>

</DIV>	
	