<?php
namespace lib\security;

use lib\EntityController;
use lib\Exception;
use lib\GoPrevException;
use lib\GoNextException;
use lib\GoCnxException;
use lib\Labels;
use lib\security\Security;
use lib\security\User;
use lib\security\Habilitation;

class SecurityController extends EntityController
{
	public static $SECURITY = array();

	protected static $ENTITY = "entities\Membre";
	protected static $PATH_VIEW_LAYOUT        = 'views/layout.php';
	protected static $PATH_VIEW_CONNECT       = 'lib/security/views/connect.php';
	protected static $PATH_VIEW_CALLRESETPWD  = 'lib/security/views/demandeChangePassword.php';
	protected static $PATH_VIEW_RESETPWD      = 'lib/security/views/changePassword.php';
	
		
	/*
	 * Action de connexion d'un Utilisateur (Formulaire de connexion)
	 */
	public function connectAction($params=null)
	{
		if ( isset($_POST[Security::getLoginName()]) ) {
			// Validation d'un Formulaire
			if ( Security::connecterUser($_POST) ) {
				throw new GoNextException ();
			}
			else {
				throw new Exception('ERR-DBIDENT');
			}
		}
		$Model['titre_page']    = "Identification de l'adhérent";
		if ( isset($_GET['currPage']) ) $Model['currPage'] = $_GET['currPage'];
		$Model['corps_page']    = static::$PATH_VIEW_CONNECT;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	/*
	 * Action de déconnexion d'un Utilisateur
	 */
	public function disconnectAction($params=null)
	{
		if ( Security::deconnecterUser() ) throw new GoCnxException ();
		throw new Exception ();
		return null;
	}
		
	/*
	 * Action de demande de réinitialisation du mot de passe (Formulaire de connexion)
	 */
	public function callResetPwdAction($params=null)
	{
		if ( isset($_POST[Security::getLoginName()]) ) {
			// Validation d'un Formulaire
			Security::demandeChangementPassword($_POST);
		}
		$Model['titre_page']   = Labels::get('TITLE-CALL-INIT-PWD');
		$Model['corps_page']   = static::$PATH_VIEW_CALLRESETPWD;
		return array(static::$PATH_VIEW_LAYOUT,$Model);	
	}

	public function changePwdAction($params=null)
	{
		$membre = null;
		
		if ( isset($_POST['validForm']) ) {
			$entityName = static::$ENTITY;
			$colPwd = $entityName::$COL_MOTDEPASSE;
			if ( empty($params['entity']) )                     throw new Exception('ERR-NOID');
			if ( !isset($_POST[$colPwd]) )                      throw new Exception ( 'ERR-PARAM-NOPARAM', array('NOM' => 'motdepasse') );
			if ( !isset($_POST[$colPwd.'Confirm']) )            throw new Exception ( 'ERR-PARAM-NOPARAM', array('NOM' => 'passwordConfirm') );
			$membre = $params['entity'];
			$membre->ChangementPassword($_POST[$colPwd],$_POST[$colPwd.'Confirm']);	
			throw new Exception('MSG-QUERYPWDUPDATE');
		}
		if ( ! Security::isConnected() && ! $membre = Security::isJetonValide($_GET) ) throw new Exception("ERR-INVALIDJETON");
		elseif ( ! empty($params['entity']) ) $membre = $params['entity'];
		else throw new Exception('ERR-NOID');
		
		// Affichage du formulaire
		$Model['titre_page']    = Labels::get('TITLE-RESET-PWD');
		$Model['corps_page']    = static::$PATH_VIEW_RESETPWD;
		$Model['entity']        = $membre;
		if ( Security::isConnected() ) return array($Model['corps_page'],$Model,true);
		else                           return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

}