<?php
namespace lib\security;

use lib\DBConnexion;
use lib\Exception;
use lib\Navigation;
use lib\GoPrevException;
use entities\Membre;

class Security {

	public static $paramConfigFile = 'config/params.ini';
	public static $SESSION_ENTRY = 'DYNAVEO_SECURITY';
	public static $LVL_PROPRIO         = 0;
	public static $LVL_ADHERENT        = 1;
	public static $LVL_ANIMATEUR       = 2;
	public static $LVL_BUREAU          = 3;
	public static $LVL_CA              = 4;
	public static $LVL_COORDINATEUR    = 5;
	public static $LVL_GESTIONNAIRE    = 6;
	public static $LVL_ADMINISTRATRUR  = 7;
	public static $LVL_CHARGEDEMISSION = 8;
	
	protected $CLASS_USER;
	protected $COL_USERNAME;
	protected $COL_MAIL;
	protected $COL_PASSWORD;
	private $user;
	
	public function __construct() 
	{
		$tabVals = parse_ini_file(static::$paramConfigFile);	// Charge le fichier de param�trage
		$this->CLASS_USER   = $tabVals['identEntity'];
		$this->COL_USERNAME = $tabVals['identlogincol'];
		$this->COL_MAIL     = $tabVals['identemailcol'];
		$this->COL_PASSWORD = $tabVals['identpwdcol'];
	}
	
	public function __get($name) 
	{
		if ( isset($this->$name) ) return $this->$name;
		else return null;
	}
	
	public function init($login,$pwd) {
		$classUser = $this->CLASS_USER;
		$filtre = $this->COL_USERNAME." = '".$login."' AND ".$this->COL_PASSWORD." = '".static::cryptePwd($pwd)."'";
		$users = $classUser::selectList($filtre);
		if ( count($users) != 1 ) return false;
		$user = current($users);
//		$user->updateDateConnexion();
		$this->user = $user;
		return true;
	}
	
	public static function cryptePwd($pwd) {
		return hash('sha512',$pwd);
	}
	
	public function getUser() {
		return $this->user;
	}
	
	public function getIdUser() {
		return $this->user->id;
	}
	
	public static function getEntityName() 
	{
		$tabVals = parse_ini_file(static::$paramConfigFile);	// Charge le fichier de param�trage
		return $tabVals['identEntity'];
	}
	
	public static function getLoginName() 
	{
		$tabVals = parse_ini_file(static::$paramConfigFile);	// Charge le fichier de param�trage
		return $tabVals['identlogincol'];
	}
	
	public static function getEMailName() 
	{
		$tabVals = parse_ini_file(static::$paramConfigFile);	// Charge le fichier de param�trage
		return $tabVals['identemailcol'];
	}

	public static function getPwdName()
	{
		$tabVals = parse_ini_file(static::$paramConfigFile);	// Charge le fichier de param�trage
		return $tabVals['identpwdcol'];
	}
	
	public static function getConnectedUser() {
		$classUser = static::getEntityName();
		if ( !isset($_SESSION) ) session_start();
		if ( !isset($_SESSION[static::$SESSION_ENTRY] ) )  return false;
		return $_SESSION[static::$SESSION_ENTRY]->getUser();
	}
	
	public static function getSessionSecurity() {
		if ( !isset($_SESSION) ) session_start();
		if ( !isset($_SESSION[static::$SESSION_ENTRY] ) )  return false;
		return $_SESSION[static::$SESSION_ENTRY];
	}

	public static function connecterUser($flux) {
		if ( !isset($_SESSION) ) session_start();
		$classeName = get_called_class();
		$security = new $classeName();
		if ( !empty($flux[$security->COL_USERNAME]) && !empty($flux[$security->COL_PASSWORD])) {
			if ( $security->init($flux[$security->COL_USERNAME],$flux[$security->COL_PASSWORD]) )
			{
				if ( isset($_SESSION[static::$SESSION_ENTRY]) ) unset($_SESSION[static::$SESSION_ENTRY]);
				Navigation::unsetNavigation();
				$_SESSION[static::$SESSION_ENTRY] = $security;
				return true;
			}
		}
		return false;
	}
	
	public static function demandeChangementPassword($flux) {
		if ( empty($flux[static::getLoginName()]) ) throw new Exception("ERR-CALLINITPWD");
		$identifiant = addslashes($flux[static::getLoginName()]);
		$filtre = "(".static::getLoginName()." like '" . $identifiant . "' OR ".static::getEMailName()." like '" . $identifiant . "')";
		$userEntity = static::getEntityName();
		$users = $userEntity::selectList($filtre);
		if ( count($users) == 1 ) {
			$user = current($users);
			$user->demandeChangementPassword();
			throw new GoPrevException("MSG-CALLINITPWD");
		}	
		else throw new Exception("ERR-CALLINITPWD");
	}
	
	public static function isJetonValide($flux) {
		if ( empty($flux['jeton']) ) throw new Exception("ERR-INVALIDJETON");
		$jeton = addslashes($flux['jeton']);
		$filtre = "(jeton = '" . $jeton . "')";
		$userEntity = static::getEntityName();
		$users = $userEntity::selectList($filtre);
		if ( count($users) == 1 ) {
			$user = current($users);
			if ( $user->isJetonValid() ) return $user;
		}	
		return false;
	}

	public static function deconnecterUser() {
		if ( !isset($_SESSION) ) session_start();
		if ( isset($_SESSION[static::$SESSION_ENTRY]) ) unset($_SESSION[static::$SESSION_ENTRY]);
		Navigation::unsetNavigation();
		return true;
	}

	public static function isProprio($idUser) {
		if ( !isset($_SESSION) ) session_start();
		if ( isset($_SESSION[static::$SESSION_ENTRY]) ) {
			if ( $_SESSION[static::$SESSION_ENTRY]->getIdUser() == $idUser ) return true;
		}
		return false;
	}
	
	public static function isConnected() {
		if ( !isset($_SESSION) ) session_start();
		if ( isset($_SESSION[static::$SESSION_ENTRY]) ) {
			return true;
		}
		return false;
	}

	public static function isAdherent() {
		return static::isHabilit(static::$LVL_ADHERENT);
	}

	public static function isAnimateur() {
		return static::isHabilit(static::$LVL_ANIMATEUR);
	}

	public static function isBureau() {
		return static::isHabilit(static::$LVL_BUREAU);
	}

	public static function isCA() {
		return static::isHabilit(static::$LVL_CA);
	}

	public static function isCoordinateur() {
		return static::isHabilit(static::$LVL_COORDINATEUR);
	}

	public static function isGestionnaire() {
		return static::isHabilit(static::$LVL_GESTIONNAIRE);
	}

	public static function isChargeDeMission() {
		return static::isHabilit(static::$LVL_CHARGEDEMISSION);
	}

	public static function isAdmin() {
		return static::isHabilit(static::$LVL_ADMINISTRATRUR);
	}

	public static function isHabilit($habilit,$obj=null)
	{
		if ( $user = static::getConnectedUser() ) 
		{
			$userRoles = $user->roles;
			if ( is_bool($habilit) && $habilit ) return true;
			if ( isset($userRoles[static::$LVL_ADMINISTRATRUR]) ) return true;
			if (is_array($habilit) ) {
				foreach ($habilit as $idValid) {
					if ( $idValid == static::$LVL_PROPRIO && $obj != null && $obj->isProprio() ) return true;
					elseif (  isset($userRoles[$idValid]) ) return true;
				}
			}
			else if (is_int($habilit) && isset($userRoles[$habilit]) ) return true;
		}
		return false;
	}
}

?>