<?php
namespace lib\attributs;

use lib\attributs\Attribut;

class Liste extends Attribut 
{

	protected $object;
	protected $order;
	protected $colRef;
	protected $idCibleValue;
	protected $idCible;
	private   $lstToInsert;
	private   $filtre;
	
	public function __construct($libelle,$value,$object,$idCible,$colRef,$order=null,$idCibleValue=null,$nullable=false,$readonly=false,$disabled=false,$filtre=null) 
	{
		parent::__construct($libelle,$value,$nullable,$readonly,$disabled);
		$this->object       = $object;
		$this->order        = $order;
		$this->idCible      = $idCible;
		$this->colRef       = $colRef;
		$this->idCibleValue = $idCibleValue;
		$this->filtre       = $filtre;
		$this->lstToInsert  = array();
	}

	public function __set($name,$value) 
	{
		switch ($name)
		{
			case 'idCibleValue' :
				$this->idCibleValue = intval($value);
				break;
			default :
				parent::__set($name, $value);
				break;
		}
	}

	public function __get($name) 
	{
		switch ($name)
		{
			case 'displayInline' :
				$str = "";
				foreach ( $this->getValue() as $elmt ) {
					if ( $str != "" ) $str .= ', ';
					$str .= (string)$elmt;
				}
				return $str;
				break;
			default :
				return parent::__get($name);
				break;
		}
	}

	public function __toString()
	{
		return $this->affiche();
	}

	public function affiche($idBase=0,$hasBotton=false)
	{
		$str = '';
		foreach ( $this->getValue() as $elmt ) {
			$strElmt = (string)$elmt;
			if ($hasBotton) $strElmt .= $elmt->displayOptions();
			if ( $idBase == 0 || $idBase != $elmt->id  ) $str .= '<DIV class="ligneTabLst">'.$strElmt.'</DIV>';
		}
		return $str;	
	}

	public function printLst()
	{
		$str = '';
		foreach ( $this->getValue() as $elmt ) {
			if ( !empty($str) ) $str .= ' | ';
			$str .= (string)$elmt;
		}
		return $str;	
	}

	public function displayCell($idParent,$edit=false,$boutons=false,$urlDisplay=null,$force=false,$params=array())
	{
		if ( $urlDisplay == null ) $urlDisplay = "lib/views/displayElmt.php";
		$cpt = 1;
		$liste = $this->getValue();
		if ( count($liste) == 0 && $force ) $liste = array( new $this->object() );
		$divParams = "";
		foreach ( $params as $key => $val ) $divParams .= $key.'="'.$val.'" ';
		if ( !isset($params['id']) ) $divParams .= 'id="'.$this->libelle.'" ';
		$display  = '<DIV data-pos="' . (count($liste)+1) . '" '.$divParams.'>';
		$display .= '<INPUT type="hidden" name="' . $this->libelle . '" value="true" />';
		foreach ( $liste as $elmt ) {
			$Model['entity']   = $elmt;
			$Model['pos']      = ( isset($params['ventile']) ) ? $params['ventile'].'_'.$cpt : $cpt;
			$Model['boutons']  = $boutons;
			$Model['edit']     = $edit;
			$Model['idParent'] = $idParent;
			ob_start();
			include $urlDisplay;
			$display .= ob_get_clean();	
			$cpt++;
		}
		$display .= '</DIV>';
		return $display;
	}

	public static function displayForm($inits=null,$pos=0,$filtre=null)
	{
		$lst = Parcour::selectList($filtre);
		$str  = '<SELECT name="id_parcour_'.$pos.'">';
		foreach ( $lst as $parcour ) {
			$selected = "";
			if ( $inits != null ) {
				foreach ( $inits as $init ) 
					if ( $init->id == $parcour->id ) $selected = "SELECTED";
			}
			$str .= '	<OPTION value="'.$parcour->id.'" '.$selected.'> '.$parcour.' </OPTION>';
		}
		$str  .= '</SELECT>';
		return $str;
	}
	
	protected function &getValue()
	{
		if ( empty($this->value) )
		{
			if ( !empty($this->idCibleValue) ) 
			{
				$className = $this->object;
				$filtre = $this->idCible."=".$this->idCibleValue;
				if ( $this->filtre != null ) {
					$filtre .= ' AND ' . $this->filtre;
				}
				$this->value = $className::selectList($filtre,$this->order);
			}
			else $this->value = array();
		}
		return $this->value;
	}
	
	protected function setValue($value)
	{
		if ( !empty($value) )
		{
			$objet = $this->object;
			$idCible = $this->idCible;
			if ( empty($this->value) ) $this->value = array();
			
			foreach ( $value as $key => $obj ) 
			{
				$pos = $obj->id;
				$lst = $this->value;
				if ( empty($pos) ) {
					$pos = $key;
					$obj->aAjouter();
				}
				$this->value[$pos] = $obj;
			}
		}
	}
	
	public function add($liste)
	{
		$listeOri = $this->deleteAll();
		if ( !empty($liste) )
		{
			foreach ( $liste as $obj ) 
			{
				if ( $obj->id != null ) 
				{
					if ( isset($listeOri[$obj->id]) ) {
						$obj->aModifier(); 		// Marque la modification comme tant une mise a jour pour la nouvelle valeur
					}
					else {
						$obj->aAjouter();		// Marque la modification comme tant une insertion pour la nouvelle valeur
					}
					$listeOri[$obj->id] = $obj;	// Insertion d'une valeur dj existante en base (relation)
				}
				else 
				{
					$obj->aAjouter();			// Marque la modification comme tant une insertion pour la nouvelle valeur
					$listeOri[] = $obj; 		// Insertion d'une valeur cre de toute piece.
				}
			}
		}
		$this->value = $listeOri;
	}
	
	public function &queryValue()
	{
		return null;
	}
	
	public function deleteAll()
	{
		$listeOri = $this->getValue();
		foreach ( $listeOri as $obj ) 
		{
			if ( $obj->changed == 0 ) $obj->aSupprimer();
			$listeOri[$obj->id] = $obj;
		}
		$this->value = $listeOri;
		$this->isUpdate();
		return $this->value;
	}
	
	public function deleteVal($indx)
	{
		$this->value[$indx]->aSupprimer();
		$this->isUpdate();
	}
	
	public function initVal()
	{
		$this->value = array();
		$this->isUpdate();
	}
}
