<?php
namespace lib\attributs;

use lib\attributs\Attribut;

class Entier extends Attribut {

	protected function setValue($value)
	{
		$this->value = intval($value);
	}
	
	public function queryValue()
	{
		return $this->value;
	}

	public function querySetValue($attrName=null)
	{
		if ( !empty($this->value) || is_int($this->value) || is_float($this->value) ) 
		{
			return $attrName." = ".$this->queryValue();
		}
		elseif ( $this->nullable && !$this->readonly ) 
		{
			return $attrName."= NULL";
		}
		return null;
	}
	
}
