<?php
namespace lib\attributs;

use lib\DBConnexion;
use lib\attributs\Attribut;

class DateHeure extends Attribut {

	private static $MOIS = array(1 => 'Janvier', 2 => 'Février', 3 => 'Mars', 4 => 'Avril', 5 => 'Mai', 6 => 'Juin', 7 => 'Juillet', 8 => 'Août', 9 => 'Septembre', 10 => 'Octobre', 11 => 'Novembre', 12 => 'Décembre');
	private static $JOUR = array(1 => 'Lundi', 2 => 'Mardi', 3 => 'Mercredi', 4 => 'Jeudi', 5 => 'Vendredi', 6 => 'Samedi', 0 => 'Dimanche');
	
	public function __get($name)
	{
		switch ($name)
		{
			case 'date' : 
				if ( $this->value == null ) return '';
				return date ('d/m/Y', strtotime($this->value));
				break;
			case 'dateStr' : 
				if ( $this->value == null ) return '';
				$jourStr = static::getLibelleJour(intval(date ('w', strtotime($this->value))));
				$jour    = date ('d', strtotime($this->value));
				$mois    = static::getLibelleMois(intval(date ('m', strtotime($this->value))));
				return $jourStr." ".$jour." ".$mois;
				break;
			case 'jourStr' : 
				if ( $this->value == null ) return '';
				return static::getLibelleJour(intval(date ('w', strtotime($this->value))));
				break;
			case 'moisStr' : 
				if ( $this->value == null ) return '';
				return static::getLibelleMois(intval(date ('m', strtotime($this->value))));
				break;
			case 'heure' : 
				if ( $this->value == null ) return '';
				return date ('H:i:s', strtotime($this->value));
				break;
			case 'h' : 
				if ( $this->value == null ) return '';
				return date ('H', strtotime($this->value));
				break;
			case 'm' : 
				if ( $this->value == null ) return '';
				return date ('i', strtotime($this->value));
				break;
			case 's' : 
				if ( $this->value == null ) return '';
				return date ('s', strtotime($this->value));
				break;
			case 'jour' : 
				if ( $this->value == null ) return '';
				return date ('d', strtotime($this->value));
				break;
			case 'mois' : 
				if ( $this->value == null ) return '';
				return date ('m', strtotime($this->value));
				break;
			case 'annee' : 
				if ( $this->value == null ) return '';
				return date ('Y', strtotime($this->value));
				break;
			case 'heureMin' : 
				if ( $this->value == null ) return '';
				return date ('H\Hi', strtotime($this->value));
				break;
			default:
				return parent::__get($name);
				break;
		}
	}

	protected function getValue()
	{
		return date ('Y-m-d H:i:s', strtotime($this->value));
	}
	
	protected function setValue($value)
	{
		$value = str_replace('h',':',$value);
		$value = str_replace('H',':',$value);
		if ( preg_match('#^[0-9]{2}/[0-9]{2}/[0-9]{4} [0-9]{2}:[0-9]{2}:[0-9]{2}$#',$value) )
			$this->value = static::strToDateTime( $value );
		elseif ( preg_match('#^[0-9]{2}/[0-9]{2}/[0-9]{4}$#',$value) )
			$this->value = static::strToDate( $value );
		elseif ( preg_match('#^[0-9]{1,2}:[0-9]{2}:[0-9]{2}$#',$value) )
			$this->value = static::strToTime( $value );
		elseif ( preg_match('#^[0-9]{1,2}:[0-9]{2}$#',$value) )
			$this->value = static::strToTime( $value.':00' );
		elseif ( preg_match('#^[0-9]{1,2}:$#',$value) )
			$this->value = static::strToTime( $value.'00:00' );
		else $this->value = $value;
	}
	
	public function queryValue()
	{
		if ( $this->value == null ) return 'NULL';
		else return "'".$this->value."'";
	}
	
	public static function strToDateTime($string) 
	{
		if ( empty($string) ) return null;
		else return \DateTime::createFromFormat('d/m/Y H:i:s', addslashes ($string))->format('Y-m-d H:i:s');
	}
	
	public static function strToDate($string) 
	{
		if ( empty($string) ) return null;
		else return \DateTime::createFromFormat('d/m/Y', addslashes ($string))->format('Y-m-d');
	}
	
	public static function strToTime($string) 
	{
		if ( empty($string) ) return null;
		else return \DateTime::createFromFormat('d/m/Y H:i:s', addslashes ("01/01/1970 $string"))->format('Y-m-d H:i:s');
	}
	
	public static function getLibelleMois($val) 
	{
		return static::$MOIS[$val];
	}
	
	public static function getLibelleJour($val) 
	{
		return static::$JOUR[$val];
	}
	
	public function add($intervale) 
	{
		$date = new \DateTime($this->{static::$COL_DATECERTIF});
		return $date->add(new \DateInterval($intervale));
	}
	
	public function higherThanToday($intervale=null) 
	{
		$date = new \DateTime($this->value);
		if ( !empty($intervale) ) $date->add(new \DateInterval($intervale));
		$today = static::now();
		if ( $today <= $date ) return true;
		else return false;
	}
	
	public static function now() 
	{
		return new \DateTime();
	}
	
}
