<?php
namespace lib\attributs;

use lib\security\Security;

abstract class Attribut {
	protected $value;
	protected $nullable;
	protected $readonly;
	protected $disabled;
	protected $confirm;
	protected $isUpdate;
	protected $libelle;
	
	public function __construct($libelle,$value=null,$nullable=false,$readonly=false,$disabled=false,$confirm=false) {
		$this->libelle  = $libelle;
		$this->value    = $value;
		$this->nullable = $nullable;
		$this->readonly = $readonly;
		$this->disabled = $disabled;
		$this->confirm = $confirm;
		$this->isUpdate = false;
	}

	public function __get($name) {
		if ( $name == 'value' ) return $this->getValue();
		elseif ( isset($this->$name) ) return $this->$name;
		else return null;
	}

	public function __set($name,$value) {
		if ( $name == 'value' ) $this->setValue($value);
		elseif ( isset($this->$name) ) $this->$name = $value;
		$this->isUpdate();
	}
	
	public function __toString() {
		return (string)$this->value;
	}
	
	protected function getValue()
	{
		return $this->value;
	}
	
	protected function setValue($value)
	{
		$this->value = $value;
	}
	
	public function queryCol()
	{
		return $this->libelle;
	}

	public abstract function queryValue();

	public function isUpdate() {
		$this->isUpdate = true;
	}

	public function isNotUpdate() {
		$this->isUpdate = false;
	}

	public function type() {
		$strClass = get_class($this);
		return strtolower( substr( $strClass , strripos( $strClass , '\\' )+1 ) );
	}

	public function querySetValue($attrName=null)
	{
		if ( !empty($this->value) ) 
		{
			return $attrName." = ".$this->queryValue();
		}
		elseif ( $this->nullable && !$this->readonly ) 
		{
			return $attrName."= NULL";
		}
		return null;
	}
	
}
