<?php
namespace lib;

use lib\Msgs;
/**
 * @author cuicui
 *
 */
class Exception extends \Exception
{
	/**
	 * @param string $codeErr
	 * @param string $params
	 */
	function __construct($codeErr=null,$params=null) {
		parent::__construct(static::getMsg($codeErr,$params));
	}
	
	public static function getMsg($codeErr=null,$params=null) {
		$errMsg = null;
		if ( !empty($codeErr) ) {
			$errMsg = Msgs::get($codeErr);
			if ( ! $errMsg )  $errMsg = "Erreur : ($codeErr).";
			if ( !empty($params) ) {
				foreach( $params as $key => $value ) {
					$errMsg = str_replace ( '#'.$key.'#' , $value , $errMsg );
				}
			}
			$errMsg .= '<br />';
		}
		return $errMsg;
	}
}
?>
