<?php
namespace lib;

use lib\Exception;
use lib\Entity;
use lib\security\Security;
use lib\attributs\Key;
use lib\attributs\Relation;

/**
 * @author cuicui
 *
 */
abstract class EntityRelation extends Entity 
{
	
	public static $COL_ID             = 'idParent';
	protected static $NAME_ENTITY     = 'entities\\Classe';
	public static $COL_ID_REL         = 'idRel';
	protected static $NAME_ENTITY_REL = 'entities\\ClasseRel';
	
	/**
	 * __construct
	 * Initialise l'instance : 
	 *   - Si parametre null objet vierge
	 *   - Si parametre = int (id) initialise l'instance avec la BD
	 *   - Si parametre = array  initialise les atributs avec les valeurs du tableau
	 * @param $data=null : identifiant (int) ou tableau de valeurs (index = nom des colonnes)
	 */
	public function __construct($data=null,$idRelation=null)
	{
		$id = static::$COL_ID;
		$this->$id = null;
		$this->changed = 0;
		$this->initAttributs();
		$this->attributs[static::$COL_ID] = new Key(static::$COL_ID);
		if ( $data != null ) {
			if ( is_array($data) ) {
				// On a passe un tableau avec des valeurs en parametres
				$this->setAttributes($data);
			}
			else {
				// On a passe des identifiants en parametre
				$idRel = static::$COL_ID_REL;
				$this->$id = $data;
				$this->$idRel = $idRelation;
				$this->select();
			}
		}
	}
	
	/**
	 *  __toString
	 * Methode d'affichage de l'entité
	 *   - Retourne une chaine de caractère 
	 * @param $name : nom (string) de l'index
	 * @return string
	 */
   public function __toString()
    {
		$relCol = static::$COL_ID_REL;
        return (string)$this->$relCol;
    }
	
	/**
	 *  __get
	 * Methode d'acces en lecture aux attributs
	 *   - Retourne l'entree 'value' de l'attribut 'attributs' pour l'index passe en parametre 
	 * @param $name : nom (string) de l'index
	 * @return object
	 */
	public function __get($name) 
	{
		if ( $name == "changed" ) {
			return $this->changed;
		}
		elseif ( isset($this->attributs[$name]) ) {
			return parent::__get($name);
		}
		else {
			return $this->attributs[static::$COL_ID_REL]->value->$name;
		}
	}

	/**
	 * getAttributs
	 * Methode d'acc�s � la liste des attributs si pas de param�tre.
	 * @return array liste des sp�cifications de l'attributattributs
	 */
	public function &getAttribut($name) {
		// Acces a l'identifiant
		if ( isset($this->attributs[$name]) ) {
			if ( $this->attributs[$name]->type() == "liste" ) $this->attributs[$name]->idCibleValue = $this->id;
			return $this->attributs[$name];
		}
		// ERREUR
		else {
			$objRel   = $this->attributs[static::$COL_ID_REL]->value;
			return $objRel->getAttribut($name);
		}
	}
	
	/**
	 * initAttributs
	 * Methode Abstraite, doit a�tre implemente dans les classes filles.
	 * Initialise les attributs de l'objet dans le tableau $attributs.
	 *   - attributs : colonnes de la table
	 */
	protected function initAttributs()
	{
		$this->attributs = array(
			static::$COL_ID     => new Relation(static::$COL_ID,null,static::$NAME_ENTITY),
			static::$COL_ID_REL => new Relation(static::$COL_ID_REL,null,static::$NAME_ENTITY_REL),
		);
	}
	
	/**
	 * notPrimary
	 * retourne si oui ou non l'attribut passe en parametre est une partie de la cle primaire (ID par defaut) de la table.
	 * Si la cle primaire est compose de plus d'1 colonne cette methode DOIT $etre surchargee dans la classe fille.
	 * @param $attribut : Nom de l'attribut � tester
	 * @return boolean
	 */
	protected function notPrimary($attribut) {
		if ( $attribut != static::$COL_ID && $attribut != static::$COL_ID_REL ) return true;
		else return false;
	}
	
	/**
	 * displayClauseWhere
	 * retourne le filtre minimal pour trouver un objet au moyen de sa cle primaire (ID par defaut).
	 * Si la cle primaire est compose de plus d'1 colonne cette methode DOIT $etre surchargee dans la classe fille.
	 * @return string
	 */
	protected function displayClauseWhere()
	{
		$id = static::$COL_ID;
		$idRel = static::$COL_ID_REL;
		return "(" . static::$COL_ID." = ".$this->$id . " AND " . static::$COL_ID_REL." = ".$this->$idRel->id . ")";
	}
	
	/**
	 * displayColomnsNames
	 * retourne le la liste des noms de colonnes s�par�es par des ",".
	 * @return string
	 */
	protected function displayColomnsNames()
	{
		$str = "";
		foreach ($this->attributs as $attrName => $attrParams) 
		{
			$valeur = $attrParams->value;
			if ( !empty( $valeur ) || is_numeric( $valeur ) ) 
			{
				if ( !empty($str) ) $str .= ",";
				$str .= $attrParams->queryCol();
			}
			else 
			{
				if ( ! $attrParams->nullable ) 
				{
					throw new Exception ( 'ERR-FORM-OBLIGAT', array('ATTRIBNAME' => $attrName." (".$this->getTableName().")" ) );
				}
			}
		}
		return $str;
	}

	/**
	 * displayColomnsValues
	 * retourne le la liste des valeurs de colonnes s�par�es par des ",".
	 * @return string
	 */
	protected function displayColomnsValues()
	{
		$id = "";
		$str = $this->$id;
		foreach ($this->attributs as $attrName => $attrParams) 
		{
			$valeur = $attrParams->value;
			if ( !empty( $valeur ) || is_numeric( $valeur ) ) 
			{
				if ( !empty($str) ) $str .= ",";
				$str .= $attrParams->queryValue();
			}
			else {
				if ( !$attrParams->nullable ) {
					throw new Exception ( 'ERR-FORM-OBLIGAT', array('ATTRIBNAME' => $attrName ) );
				}
			}
		}
		return $str;
	}

	private static function getStaticNomRelTable()
	{
		$tabVals = parse_ini_file('config/params.ini');	// Charge le fichier de parametrage pour recuperer l'extension des tables 
		$classeName = static::$NAME_ENTITY_REL;
		$posSlash = 0;
		if ( strrpos( $classeName , '\\' ) ) $posSlash = strrpos($classeName,'\\')+1;
		$classeName = substr($classeName,$posSlash);
		return $tabVals['dbextension'] . strtolower($classeName);
	}
	
	/**
	 * @param string $filtres
	 * @param string $ordre
	 * @param string $limite
	 * @throws Exception
	 * @return multitype:unknown 
	 */
	public static function selectList($filtres=null,$ordre=null,$groupBy=null,$limite=null)
	{
		global $dbcnx;
		$cnx = &$dbcnx;
		$classeName    = get_called_class();
		$classeNameRel = static::$NAME_ENTITY_REL;
		$tableName     = static::getStaticNomTable();
		$tableNameRel  = static::getStaticNomRelTable();
		$colIdRel = $classeNameRel::$COL_ID;
		$tabRet = array();
		$errmsg = " Select liste (Table ".$tableName.") : ";
		
		$query = "SELECT * FROM ".$tableName.",".$tableNameRel;
		if ( !empty($filtres) ) $query .= " WHERE ".$tableName.".".static::$COL_ID_REL." = ".$tableNameRel.".".$colIdRel." AND ".$filtres;
		if ( !empty($groupBy) ) $query .= " GROUP BY ".$groupBy;
		if ( !empty($ordre) )   {
			$lst = (new $classeName())->getAttributs();
			if ( !isset($lst[$ordre]) ) $ordre = $tableNameRel.'.'.$ordre;
			$query .= " ORDER BY ".$ordre;
		}
		else $query .= " ORDER BY 2";
		if ( !empty($limite) )  $query .= " LIMIT ".$limite;

		$res = $cnx->select($query);
		foreach ( $res as $ligne ) {
			$obj = new $classeName( $ligne[static::$COL_ID],  $ligne[static::$COL_ID_REL] );
			$obj->aSupprimer();
			$tabRet[$ligne[static::$COL_ID_REL]] = $obj;
		}
		return $tabRet;
	}
	
}

?>