<?php
namespace lib;

use lib\Parametres;
use lib\Exception;
use lib\security\Security;
use lib\attributs\Key;

/**
 * @author cuicui
 *
 */
abstract class Entity {
	
	public static $TAB_PREFIX  = '';
	public static $COL_ID      = 'id';
	public static $COL_PROPRIO = 'id_proprietaire';
	public static $FIC_TRACES  = 'data/traces/MembresQuery.trc';
	public static $LVL_TRACES  = array( 'select' => false, 'insert' => false, 'update' => false, 'updatePwd' => false, 'delete' => false );
	
//	protected $id;
	/**
	 * Liste des attributes de l'entite
	 * @var array
	 */	
	protected $attributs;

	protected $cnx;
	protected $changed;
	
	/**
	 * __construct
	 * Initialise l'instance : 
	 *   - Si parametre null objet vierge
	 *   - Si parametre = int (id) initialise l'instance avec la BD
	 *   - Si parametre = array  initialise les atributs avec les valeurs du tableau
	 * @param $data=null : identifiant (int) ou tableau de valeurs (index = nom des colonnes)
	 */
	public function __construct($data=null)
	{
		$id = static::$COL_ID;
		$this->noAction();
		$this->initAttributs();
		$this->attributs[static::$COL_ID] = new Key(static::$COL_ID);
		$this->$id = null;
		if ( $data != null ) {
			if ( is_array($data) ) {
				// On a passe un tableau avec des valeurs en parametres
				$this->setAttributes($data);
			}
			else {
				// On a passe un identifiant en parametre
				$this->$id = $data;
				$this->select();
			}
		}
	}
	
	/**
	 *  addGetter
	 * Methode personakisable permettant de surcharger la methode __get
	 *   - Retourne une string à afficher ou false si le nom d el'attribut n'est pas géré. 
	 * @param $name : nom (string) de l'index
	 * @return $string | false
	 */
	protected function addGetter($name)
	{
		return false;
	}

	/**
	 *  __get
	 * Methode d'acces en lecture aux attributs
	 *   - Retourne l'entree 'value' de l'attribut 'attributs' pour l'index passe en parametre 
	 * @param $name : nom (string) de l'index
	 */
	public function __get($name) 
	{
		
		$addGetter = $this->addGetter($name);
		if ( $addGetter ) return $addGetter;

		switch ( $name ) {
			case 'id' :
				return $this->attributs[static::$COL_ID]->value;
				break;
			case 'idClause' :
				return static::$TAB_PREFIX.static::$COL_ID."=".$this->attributs[static::$COL_ID]->value;
				break;
			case 'changed' :
				return $this->changed;
				break;
			default :
				if ( isset($this->attributs[$name]) )
				{
					if ( $this->attributs[$name]->type() == "liste" ) $this->attributs[$name]->idCibleValue = $this->id;
					return $this->attributs[$name]->value;
				}
				break;
		}
		return false;
	}
	
	/**
	 *  addSetter
	 * Methode personakisable permettant de surcharger la methode __set
	 *   - True ou false si le nom de l'attribut n'est pas géré. 
	 * @param $name : nom (string) de l'index
	 * @param $value : valeur à affecter à l'attribut
	 * @return boolean
	 */
	protected function addSetter($name,$value)
	{
		return false;
	}

	/**
	 *  __set
	 * METHODE D'ACCES AUX ATTRIBUTS EN ECRITURE
	 *   - Initialise l'entree 'value' de l'attribut 'attributs' pour l'index passe en parametre 
	 * @param $name : nom (string) de l'index
	 * @param $value : valeur (variable)
	 */
	public function __set($name, $value) 
	{
		
		$addSetter = $this->addSetter($name,$value);
		if ( $addSetter ) return $addSetter;

		if ( isset($this->attributs[$name]) )
		{
			$this->attributs[$name]->value = $value;
			$this->attributs[$name]->isUpdate();
		}
		else
			return false;
	}

	/**
	 * getAttributs
	 * Methode d'acc�s � la liste des attributs si pas de param�tre.
	 * @return array liste des sp�cifications de l'attributattributs
	 */
	public function getAttributs() {
		return $this->attributs;
	}

	/**
	 * getAttributs
	 * Methode d'acc�s � la liste des attributs si pas de param�tre.
	 * @return array liste des sp�cifications de l'attributattributs
	 */
	public function &getAttribut($name) {
		// Acces a l'identifiant
		$ret = false;
		if ( isset($this->attributs[$name]) )
		{
			if ( $this->attributs[$name]->type() == "liste" ) $this->attributs[$name]->idCibleValue = $this->id;
			return $this->attributs[$name];
		}
		// ERREUR
		else
			return $ret;
	}
	
	/**
	 * initAttributs
	 * Methode Abstraite, doit a�tre implemente dans les classes filles.
	 * Initialise les attributs de l'objet dans le tableau $attributs.
	 *   - attributs : colonnes de la table
	 */
	abstract protected function initAttributs();
	
	/**
	 * initCnx
	 * Initialise l'attribut connexion a� la base de donnee avec la variable globale '$dbcnx'.
	 */
	protected function &initCnx()
	{
		global $dbcnx;
		return $dbcnx;
	}
	
	/**
	 * notPrimary
	 * retourne si oui ou non l'attribut passe en parametre est une partie de la cle primaire (ID par defaut) de la table.
	 * Si la cle primaire est compose de plus d'1 colonne cette methode DOIT $etre surchargee dans la classe fille.
	 * @param $attribut : Nom de l'attribut � tester
	 * @return boolean
	 */
	protected function notPrimary($attribut) {
		if ( $attribut != static::$COL_ID ) return true;
		else return false;
	}
	
	/**
	 * notPrimary
	 * retourne si oui ou non l'attribut passe en parametre est une partie de la cle primaire (ID par defaut) de la table.
	 * Si la cle primaire est compose de plus d'1 colonne cette methode DOIT $etre surchargee dans la classe fille.
	 * @param $attribut : Nom de l'attribut � tester
	 * @return boolean
	 */
	public function getIdName() {
		return static::$COL_ID;
	}

	/**
	 * aSupprimer
	 * marque l'attribut changed a� la valeur 3 (Enregsitrement a� surpprimer dans la BD)
	 */
	public function noAction()
	{
		$this->changed = 0;
	}
	
	/**
	 * aAjouter
	 * marque l'attribut changed a� la valeur 1 (Enregsitrement a� ajouter dans la BD)
	 */
	public function aAjouter()
	{
		$this->changed = 1;
	}

	/**
	 * aModifier
	 * marque l'attribut changed a� la valeur 2 (Enregsitrement a� modifier dans la BD)
	 */
	public function aModifier()
	{
		$this->changed = 2;
	}

	/**
	 * aSupprimer
	 * marque l'attribut changed a� la valeur 3 (Enregsitrement a� surpprimer dans la BD)
	 */
	public function aSupprimer()
	{
		$this->changed = 3;
	}
	
	/**
	 * displaySetValues
	 * initialise les attributs de l'entite au moyen d'un tableau associatif
	 * @param $flux : Tableau associtif contenant les valeurs des attributs
	 */
	public function setAttributes($flux,$pos=0)
	{
		$id = static::$COL_ID;
		
		if ( !empty($flux[$id]) ) $this->$id = $flux[$id];
		$idvalue = $this->$id;
			
		if ( empty($idvalue) )              $this->changed = 1;	// L'identifiant n'est pas renseigne, On marque pour INSERT
		elseif( isset($flux['validForm']) ) $this->changed = 2;	// L'indentifiant est renseigne, on marque pour UPDATE
		else                                $this->changed = 0;	// NON MODIFIE

		foreach ($this->getAttributs() as $attrName => $attrParams) 
		{
			$attrParams->isNotUpdate();
			$valeur = null;
			if ( isset($flux[$attrName]) ) 
				$valeur = $flux[$attrName];
			elseif ( isset($flux[$attrName.'_'.$pos]) ) 
				$valeur = $flux[$attrName.'_'.$pos];
			
			if ( $attrParams->type() == "colonne" ) continue; 
			if ( $attrParams->type() == "password" ) continue; 
			if ( $attrParams->type() == 'file' ) {
				if ( is_array($valeur) ) {
					$valeur = $valeur[$pos];
				}
				$colname = $attrParams->colname;
				$colmime = $attrParams->colmime;
				$colsize = $attrParams->colsize;
				if ( !empty($valeur) ) {
					if  ( isset( $_FILES[$valeur] ) && !empty($_FILES[$valeur]['name']) )  {
						$attrParams->value = $_FILES[$valeur];
						// Teste les extensions de fichiers autorisés.
						if ( method_exists( $this , 'isTypeOk' ) && !$this->isTypeOk($attrParams->extension) ) throw new Exception('ERR-EXTENSIONINTERDITE',array( 'EXTENSION' => $attrParams->extension ));
						$attrParams->isUpdate();
					}
				}
				elseif ( isset( $flux[$attrParams->colname] ) ) {
					$attrParams->name = $flux[$colname];
					$attrParams->mime = $flux[$colmime];
					$attrParams->size = $flux[$colsize];
				}
			}
			elseif ( $attrParams->type() == 'liste' ) 
			{
				if ( isset($flux['validForm']) && !empty($valeur) && $valeur ) 
				{
					$listori = $this->$attrName;
					$attrRef = $attrParams->colRef;
					$liste = null;
					if ( isset($flux[$attrRef]) ) {
						$liste = array();
						$max = count($flux[$attrRef]);
						$obj = $attrParams->object;
						$cpt = 0;
						for ( $cpt = 0; $cpt < $max; $cpt++) 
						{
							$entity = new $obj();
							$entity->setAttributes($flux,$cpt);
							$liste[$cpt] = $entity;
						}
						$attrParams->idCibleValue = $this->id;
					}
					$attrParams->add($liste);
					$attrParams->isUpdate();
				}
			}
			elseif ( $attrParams->type() == 'choix' ) 
			{
				$lstChoix = $attrParams->values;
				$attrParams->value = key($lstChoix);
				if ( isset($valeur) ) {
					$attrParams->value = $valeur;
				}
				if ( isset($flux['validForm']) ) {
					$attrParams->isUpdate();
				}
			}
			elseif ( isset($valeur) ) {
				if ( is_array($valeur) ) {
					$attrParams->value = $valeur[$pos];
				}
				else {
					$attrParams->value = $valeur;
				}
				if ( isset($flux['validForm']) ) {
					$attrParams->isUpdate();
				}
			}
			if ( isset($flux['validForm']) && $attrParams->confirm ) {
				$valeur = $flux[$attrName.'Confirm'];
				if ( $pos != null ) $valeur = $flux[$attrName.'Confirm'][$pos];
				if (  empty($valeur) || $attrParams->value != $valeur ) 
					throw new Exception('ERR-FORM-CONFIRM',array('ATTRIBNAME' => $attrName ));
			}
			$this->attributs[$attrName] = $attrParams;
		}
	}
	
	/**
	 * displayClauseWhere
	 * retourne le filtre minimal pour trouver un objet au moyen de sa cle primaire (ID par defaut).
	 * Si la cle primaire est compose de plus d'1 colonne cette methode DOIT $etre surchargee dans la classe fille.
	 * @return string
	 */
	protected function displayClauseWhere()
	{
		$id = static::$COL_ID;
		return static::$COL_ID." = ".$this->$id;
	}
		
	/**
	 * displayColomnsNames
	 * retourne le la liste des noms de colonnes s�par�es par des ",".
	 * @return string
	 */
	protected function displayColomnsNames()
	{
		$str = '';
		foreach ($this->getAttributs() as $attrName => $attrParams) 
		{
			if ( $attrParams->type() == "colonne" ) continue; 
			if ( $attrParams->type() == "liste" ) continue; 
			$valeur = $attrParams->value;
			if ( !empty($valeur) || is_numeric( $valeur ) ) 
			{
				if ( $attrParams->queryValue() != null ) 
				{
					if ( !empty($str) ) $str .= ",";
					$str .=  $attrParams->queryCol();
				}
			}
			else 
			{
				if ( ! $attrParams->nullable ) 
				{
					throw new Exception ( 'ERR-FORM-OBLIGAT', array('ATTRIBNAME' => $attrName ) );
				}
			}
		}
		return $str;
	}

	/**
	 * displayColomnsValues
	 * retourne le la liste des valeurs de colonnes s�par�es par des ",".
	 * @return string
	 */
	protected function displayColomnsValues()
	{
		$str = '';
		foreach ($this->getAttributs() as $attrName => $attrParams) 
		{
			if ( $attrParams->type() == "colonne" ) continue; 
			if ( $attrParams->type() == "liste" ) continue; 
			$valeur = $attrParams->value;
			if ( !empty($valeur) || is_numeric( $valeur ) ) 
			{
				if ( $attrParams->queryValue() != null ) 
				{
					if ( !empty($str) ) $str .= ",";
					$str .=  $attrParams->queryValue();
				}
			}
			else {
				if ( !$attrParams->nullable ) {
					throw new Exception ( 'ERR-FORM-OBLIGAT', array('ATTRIBNAME' => $attrName ) );
				}
			}
		}
		return $str;
	}
	
	/**
	 * displaySetValues
	 * retourne le la liste des colonnes associ�es aux valeurs s�par�es par des ",".
	 * @return string
	 */
	protected function displaySetValues()
	{
		$str = '';
		foreach ($this->getAttributs() as $attrName => $attrParams) 
		{
			if ( $attrParams->type() == "colonne" ) continue; 
			if ( $attrParams->type() == "liste" ) continue; 
			if ( $attrParams->type() == "password" && !$attrParams->isUpdate ) continue; 
			$strattr = $attrParams->querySetValue($attrName);
			if ( $this->notPrimary($attrName) && $strattr != null ) 
			{
				if ( !empty($str) ) $str .= ", ";
				$str .= $strattr;
			}
		}
		return $str;
	}
	
	/**
	 * @param unknown $name
	 * @return string
	 */
	public function affiche($name) 
	{
		$id = static::$COL_ID;
		switch ( $this->getAttribut($name)->type() )
		{
			case 'choix' :
				return $this->getAttribut($name)->values[$this->$name];
				break;
			case 'file' :
				return $this->$name->name;
				break;
			case 'liste' :
				$this->getAttribut($name)->idCibleValue = $this->$id;
				return (string)$this->getAttribut($name);
				break;
			default:
				return $this->$name;
				break;
		}
	}
	
	public function isProprio() {
		$colProprio = static::$COL_PROPRIO;
		return Security::isProprio($this->$colProprio);
	}

	public function getTableName()
	{
		$tabVals = parse_ini_file('config/params.ini');	// Charge le fichier de parametrage pour recuperer l'extension des tables 
		$classeName = get_class($this);
		$posSlash = 0;
		if ( strrpos( $classeName , '\\' ) ) $posSlash = strrpos($classeName,'\\')+1;
		$classeName = substr($classeName,$posSlash);
		return $tabVals['dbextension'] . strtolower($classeName);
	}
	
	/**
	 * activeAction
	 * lance l'action de mise � jour dans la BD en fonction du niveau de changement
	 * 1 - insert
	 * 2 - update
	 * 3 - delete
	 */
	public function activeAction()
	{
		$id = static::$COL_ID;
		if ( $this->changed == 1 || $this->$id == null ) $this->insert();
		elseif ( $this->changed == 2 ) $this->update();
		elseif ( $this->changed == 3 ) {
			$this->delete();
			return null;
		}
		return $this;
	}
	
	private function traceTrans ($trace,$query) 
	{
		if ( isset(static::$LVL_TRACES[$trace]) && static::$LVL_TRACES[$trace] ) {
			$nomFic = substr( get_class($this) , ( strrpos( get_class($this) , '\\' ) ) ? strrpos(get_class($this),'\\')+1 : 0 );
			$nomFic = Parametres::get('pathData')."/traces/".$nomFic."Query_".date("d").".trc";
			$fichier = fopen($nomFic, 'a+');
			$user = Security::getConnectedUser();

			if ( !empty($user) ) fputs($fichier, date("d/m/Y H:i:s")."\t -> ".(string)$user." (".$user->id.") : ".$query."\n");
			else fputs($fichier, date("d/m/Y H:i:s")."\t -> ANONIMOUS : ".$query."\n");
			fclose($fichier);
		}
	}
	
	/**
	 * select
	 * Selection d'un enregistrement dans la BD
	 * @throws Exception
	 */
	public function select() 
	{
		$query = '';
		$id = static::$COL_ID;
		$idvalue = $this->$id;
		$cnx = $this->initCnx();
		$errmsg = " Select (Table ".$this->getTableName().") : ";
		if ( !empty($idvalue) )  {
			$colonnes = '*';
			$tables   = $this->getTableName();
			$where    = $this->displayClauseWhere();
			$query = "SELECT ".$colonnes." FROM ".$tables." WHERE ".$where;
			$res = $cnx->select($query);
			if ( count($res) == 1 ) {
				$ligne = current($res);
				$this->setAttributes( $ligne );
				$this->changed = 0;		// pas de modif a effectuer.
			}
			else {
				throw new Exception( 'ERR-QUERY-IDINCONNU', array('ERRMSG' => $errmsg, 'ID' => $this->$id, 'QUERY' => $query) );
			}
		}
		else {
			throw new Exception( 'ERR-QUERY-NOID',array('CIBLE' => $errmsg) );
		}
		$this->traceTrans('select',$query);
	}
	
	/**
	 * insert
	 * Insertion d'un enregistrement dans la BD
	 * @param $isTransaction=false : booleen indique si l'insertion fait partie d'une Transaction/
	 * @throws Exception
	 */
	public function insert($isTransaction=false) 
	{
		$query = '';
		$id = static::$COL_ID;
		$idvalue = $this->$id;
		$cnx = $this->initCnx();
		$cnx->transaction($isTransaction);
		foreach ($this->attributs as $attrName => $attrParams) 
		{
			if ( $attrParams->type() == "relation" ) 
			{
				$entity = $attrParams->value;
				if ( !empty($entity) ) 
				{
					$entity->activeAction();
					$this->$attrName = $entity;
				}
			}
		}
		$errmsg = " Insert (Table ".$this->getTableName().") : ";
		$query = "INSERT INTO ".$this->getTableName()." (".$this->displayColomnsNames().") VALUES (".$this->displayColomnsValues().")";
		$res = $cnx->update($query);
		$this->$id = $cnx->getInsertedId();
		
		foreach ($this->attributs as $attrName => $attrParams) 
		{
			if ( $attrParams->type() == "liste" &&  $attrParams->isUpdate ) 
			{
				$liste = $this->$attrName;
				$idCible = $attrParams->idCible;
				
				foreach ($liste as $key => $entite)
				{
					if ( $liste[$key]->$idCible == null ) {
						$liste[$key]->$idCible = $this->$id;
						$liste[$key]->activeAction();
					}
				}

				$this->$attrName = $liste;
			}
		
		}

		foreach ($this->attributs as $attrName => $attrParams) {
			if ( $attrParams->type() == "file" ) {
				$this->copieFichier($attrName);
			}
		}
		if ( $isTransaction ) $cnx->valider();
		$this->changed = 0;
		$this->traceTrans('insert',$query);
	}
		
	/**
	 * update
	 * Mise � jour d'un enregistrement dans la BD
	 * @param $isTransaction=false : booleen indique si l'insertion fait partie d'une Transaction/
	 * @throws Exception
	 */
	public function update($isTransaction=false) 
	{
		$query = '';
		$id = static::$COL_ID;
		$idvalue = $this->$id;
		$cnx = $this->initCnx();
		$cnx->transaction($isTransaction);
		foreach ($this->attributs as $attrName => $attrParams) 
		{
			if ( $attrParams->type() == "relation" ) 
			{
				$entity = $attrParams->value;
				if ( !empty($entity) ) 
				{
					$this->$attrName = $entity->activeAction();
				}
			}
		}
			
		$errmsg = " Update (Table ".$this->getTableName().") : ";
		if ( empty($idvalue) ) throw new Exception( 'ERR-QUERY-NOID',array('CIBLE' => $errmsg) );
		$setValues = $this->displaySetValues();
		if ( !empty($setValues) ) {
			$query = "UPDATE ".$this->getTableName()." SET ".$setValues." WHERE ".$this->displayClauseWhere();
			$res = $cnx->update($query);
		}
		
		foreach ($this->getAttributs() as $attrName => $attrParams) 
		{
			if ( $attrParams->type() == "liste" && $attrParams->isUpdate ) 
			{
				$liste = $this->$attrName;
				$idCible = $attrParams->idCible;
				foreach ($liste as $key => $entite)
				{
					$liste[$key]->$idCible = $this->$id;
					$liste[$key]->activeAction();
				}
				$this->$attrName = $liste;
			}
			if ( $attrParams->type() == "file" ) {
				$this->copieFichier($attrName);
			}
		}
		if ( $isTransaction ) $cnx->valider();
		$this->changed = 0;
		$this->traceTrans('update',$query);
	}
		
	/**
	 * delete
	 * Supression d'un enregistrement dans la BD
	 * @param $isTransaction=false : booleen indique si l'insertion fait partie d'une Transaction/
	 * @throws Exception
	 */
	public function delete($isTransaction=false) 
	{
		$query = '';
		$id = static::$COL_ID;
		$idvalue = $this->$id;
		$cnx = $this->initCnx();
		$cnx->transaction($isTransaction);

		$errmsg = " Delete (Table ".$this->getTableName().") : ";
		if( empty($idvalue) ) throw new Exception( 'ERR-QUERY-NOID',array('CIBLE' => $errmsg) );
		$query = "DELETE FROM ".$this->getTableName()." WHERE ".$this->displayClauseWhere();
		$res = $cnx->update($query);

		foreach ($this->attributs as $attrName => $attrParams) {
			if ( $attrParams->type() == "file" ) $this->dropFichier($attrName);
		}
				
		if ( $isTransaction ) $cnx->valider();
		$this->changed = 0;
		$this->traceTrans('delete',$query);
	}
	
	// *******************************************
	// ** Methodes STATIC
	// *******************************************
	
	public static function getStaticNomTable() {
		$tabVals = parse_ini_file('config/params.ini');	// Charge le fichier de parametrage pour recuperer l'extension des tables 
		$classeName = get_called_class();
		$posSlash = 0;
		if ( strrpos( $classeName , '\\' ) ) $posSlash = strrpos($classeName,'\\')+1;
		$classeName = substr($classeName,$posSlash);
		return $tabVals['dbextension'] . strtolower($classeName);
	}

	/**
	 * @param string $filtres
	 * @param string $ordre
	 * @param string $limite
	 * @throws Exception
	 * @return multitype:unknown 
	 */
	public static function selectList($filtres=null,$ordre=null,$groupBy=null,$limite=null)
	{
		global $dbcnx;
		$cnx = &$dbcnx;
		$classeName = get_called_class();
		$tableName = static::getStaticNomTable();
		$tabRet = array();
		$errmsg = " Select liste (Table ".$tableName.") : ";
		
		$query = "SELECT * FROM ".$tableName;
		if ( !empty($filtres) ) $query .= " WHERE ".$filtres;
		if ( !empty($groupBy) ) $query .= " GROUP BY ".$groupBy;
		if ( !empty($ordre) )   $query .= " ORDER BY ".$ordre;
		else $query .= " ORDER BY 2";
		if ( !empty($limite) )  $query .= " LIMIT ".$limite;

		$res = $cnx->select($query);
		foreach ( $res as $ligne ) {
			$tabRet[$ligne[static::$COL_ID]] = new $classeName($ligne);
		}
		return $tabRet;
	}

	/**
	 * @param string $colonnes
	 * @param string $filtres
	 * @param string $ordre
	 * @throws Exception
	 * @return multitype:unknown 
	 */
	public static function selectListForm($colonnes,$filtres=null,$ordre=null)
	{
		global $dbcnx;
		$cnx = &$dbcnx;
		$classeName = get_called_class();
		$tableName = static::getStaticNomTable();
		$errmsg = " Select liste (Table ".$tableName.") : ";
		
		$query = "SELECT ".$colonnes." FROM ".$tableName;
		if ( !empty($filtres) ) $query .= " WHERE ".$filtres;
		if ( !empty($ordre) )   $query .= " ORDER BY ".$ordre;
		else $query .= " ORDER BY 2";
		$res = $cnx->select($query);
		$str = '';
		foreach ( $res as $ligne ) {
			$strLigne = '';
			foreach ( $ligne as $col ) {
				if ( !empty($strLigne) ) $strLigne .= ' ';
				$strLigne .= $col;
			}
			$str .= '<option value="'.$strLigne.'">';
		}
		return $str;
	}
	
	public static function displayListDistinct($col,$colInit=null,$filtres=null)
	{
		global $dbcnx;
		$cnx = &$dbcnx;
		$tableName = static::getStaticNomTable();
		$errmsg = " Select DISTINCT (Table ".$tableName.") : ";
		
		$query = "SELECT ".$col." FROM ".$tableName;
		if ( !empty($filtres) ) $query .= " WHERE ".$filtres;
		$query .= " GROUP BY ".$col;
		$query .= " ORDER BY ".$col;
		$res = $cnx->select($query);
		$strRet = '<SELECT name="'.$col.'">';
		$strRet .= '<OPTION value="" SELECTED >Selectionnez une valeur</OPTION>';
		foreach ( $res as $ligne ) {
			$strSelected = '';
			if ( $colInit != null && strtoupper($colInit) == strtoupper($ligne[$col]) ) $strSelected = 'SELECTED';
			$strRet .= '<OPTION value="'.$ligne[$col].'" '.$strSelected.' >'.$ligne[$col].'</OPTION>';
		}
		$strRet .= "</SELECT>";
		return $strRet;
	}
	
	public static function selectMax($col,$filtres=null)
	{
		global $dbcnx;
		$cnx = &$dbcnx;
		$tableName = static::getStaticNomTable();
		$errmsg = " Select max (Table ".$tableName.") : ";
		
		$query = "SELECT MAX(".$col.") as max FROM ".$tableName;
		if ( !empty($filtres) ) $query .= " WHERE ".$filtres;
		$res = $cnx->select($query);
		if ( $cnx->getAffectedRows() == 1 ) {
			$ligne = current($res) ;
			return $ligne['max'];
		}
		return false;
	}
	
	public static function exist($filtres)
	{
		global $dbcnx;
		$cnx = &$dbcnx;
		$tableName = static::getStaticNomTable();
		$errmsg = " Select exist (Table ".$tableName.") : ";		
		$query = "SELECT * FROM ".$tableName." WHERE ".$filtres;
		$res = $cnx->select($query);
		if ( $cnx->getAffectedRows() > 0 ) {
			return true;
		}
		return false;
	}
	
	public static function deleteList($id)
	{
		global $dbcnx;
		$cnx = &$dbcnx;
		$table = selef::getStaticNomTable();
		$errmsg = " Delete liste (Table ".$table.") : ";
		$query = "DELETE FROM ".$table." WHERE ".static::$COL_ID." = ".$id;
		$res = $cnx->update($query);
	}
	
	public static function displayListSelect($selectName, $liste, $entiteInit=null, $obligatoire=false)
	{
		$str = "<select name=\"".$selectName."\">";
		$strSelected = "";
		if ( $entiteInit == null ) $strSelected = "SELECTED";
		if (!$obligatoire) {
			$str .= "<option value=\"\" ".$strSelected." ></option>";
			$strSelected = "";
		}
		foreach ( $liste as $elmt) {
			if ( $entiteInit != null && $entiteInit->id == $elmt->id ) $strSelected = "SELECTED";
			$str .= "<option value=\"".$elmt->id."\" ".$strSelected." >".(string)$elmt."</option>";
			$strSelected = "";
		} 
		$str .= "</select>";
		return $str;
	}
	
	public static function selectForm($valeur)
	{
		global $dbcnx;
		$cnx = &$dbcnx;
		$classeName = get_called_class();
		$tableName = static::getStaticNomTable();
		$id = static::$COL_ID;
		$str_ret = "";
		$errmsg = " Select liste (Table ".$tableName.") : ";
		
		$query = "SELECT * FROM ".$tableName." ORDER BY 2";

		$res = $cnx->select($query);
		foreach ( $res as $ligne ) {
			$entity = new $classeName($ligne);
			$selected = ( !empty($valeur->$id) && $entity->$id == $valeur->$id)? " SELECTED" : "";
			$str_ret .= '<OPTION value="'.$entity->$id.'"'.$selected.'>'.$entity.'</OPTION>';
		}
		return $str_ret;
		
	}
	
}

?>