<?php
namespace lib;
use lib\security\Security;
/**
* Classe de gestion générique des affichages
*
* Classe utilisable pour afficher certains obets de manière génériques dans les vues applicatives.
*
* @copyright  Copyright (c) 2015 DYNAVEO, COnseils et Services en Informatique
* @author Patrice Cuissard
* @version    1.0
*/

class DisplayEntity 
{
	
	/**
	* Méthode statique d'affichage d'une ligne de formulaire pour un attribut.
	* Cette méthode affiche directement sur la sortie standard.
	*
	* @param string $attName Nom de l'attribut
	* @param array $attribut Caractéristiques descriptives de l'attribut (tels que décrits par l'Entité)
	* @param string $valeur (default="") valeur par defaut de l'attribut
	* @return object Retourne l'objet Customer correspond à l'ID reçu
	*/
	public static function displayLineForm($attName,$attribut,$entity) 
	{	
		?>
			<DIV>
				<?php static::displayLabel($attName,$entity); ?>
				<?php static::displayObjForm($attName,$entity); ?>
			</DIV>
		<?php
	}
	
	/**
	* Méthode statique d'affichage du libellé d'un attribut.
	*
	* @param string $attName Nom de l'attribut
	* @param array $attribut Caractéristiques descriptives de l'attribut (tels que décrits par l'Entité)
	*/
	public static function displayLabel($attName,$entity) 
	{	
		$attribut = $entity->getAttribut($attName);
		$classe = "";
		if ( $attribut->nullable ) $classe = 'class="required"';
		echo '<LABEL '. $classe.'>'. $attribut->libelle .' : </LABEL>';
	}
	
	/**
	* Méthode statique d'affichage d'un objet formulaire en fonction du type d'attribut.
	*
	* @param string $attName Nom de l'attribut
	* @param array $attribut Caractéristiques descriptives de l'attribut (tels que décrits par l'Entité)
	* @param string $valeur (default="") valeur par defaut de l'attribut
	*/
	public static function displayObjForm($attName,$entity,$index=null) 
	{
		$idName = $attName;
		if ( $index != null ) {
			$idName = $attName.'_'.$index;
		}
		$strRet = "";
		$attribut = $entity->getAttribut($attName);
		$valeur = $entity->$attName;
		$libelle = $attribut->libelle;
		$options = '';
		if ( $attribut->nullable ) $options .= ' required';
		if ( $attribut->readonly )  {
			$options .= ' readonly';
			$libelle = "";
		}
		if ( $attribut->disabled )  {
			$options .= ' disabled';
			$libelle = "";
		}
		switch ( $attribut->type() ) 
		{
			case 'key' : 
				$strRet .= static::displayInput($attName,'hidden','',$libelle,$valeur,$options,$index);
				break;
			case 'chaine' : 
				$strRet .= static::displayInput($attName,'text','',$libelle,$valeur,$options,$index);
				if ( $attribut->confirm ) $strRet .= '<br />'.static::displayInput($attName.'Confirm','text','','confirmation',$valeur,$options,$index);
				break;
			case 'password' : 
				$strRet .= static::displayInput($attName,'password','',$libelle,'',$options,$index);
				if ( $attribut->confirm ) $strRet .= '<br />'.static::displayInput($attName.'Confirm','password','','confirmation','',$options,$index);
				break;
			case 'entier' : 
				$strRet .= static::displayInput($attName,'text','class="intForm"',$libelle,$valeur,$options,$index);
				if ( $attribut->confirm ) $strRet .= '<br />'.static::displayInput($attName.'Confirm','text','class="intForm"','confirmation','',$options,$index);
				break;
			case 'choix' : 
				$strRet .= $attribut->displayForm();
				break;
			case 'decimal' : 
				$strRet .= static::displayInput($attName,'text','class="decimalForm"',$libelle,$valeur,$options,$index);
				if ( $attribut->confirm ) $strRet .= '<br />'.static::displayInput($attName.'Confirm','text','class="decimalForm"','confirmation',$valeur,$options,$index);
				break;
			case 'uid' : 
				$strRet .= static::displayInput($attName,'text','class="uidForm"',$libelle,$valeur,$options,$index);
				if ( $attribut->confirm ) $strRet .= '<br />'.static::displayInput($attName.'Confirm','text','class="uidForm"','confirmation',$valeur,$options,$index);
				break;
			case 'mail' : 
				$strRet .= static::displayInput($attName,'mail','',$libelle,$valeur,$options,$index);
				if ( $attribut->confirm ) $strRet .= '<br />'.static::displayInput($attName.'Confirm','mail','','confirmation',$valeur,$options,$index);
				break;
			case 'tel' : 
				$strRet .= static::displayInput($attName,'tel','',$libelle,$valeur,$options,$index);
				if ( $attribut->confirm ) $strRet .= '<br />'.static::displayInput($attName.'Confirm','tel','','confirmation',$valeur,$options,$index);
				break;
			case 'date' : 
				$strRet .= static::displayInput($attName,'date','',$libelle,$valeur,$options,$index);
				if ( $attribut->confirm ) $strRet .= '<br />'.static::displayInput($attName.'Confirm','date','','confirmation',$valeur,$options,$index);
				break;
			case 'dateheure' : 
				$strRet .= static::displayInput($attName,'datetime','',$libelle,$valeur,$options,$index);
				if ( $attribut->confirm ) $strRet .= '<br />'.static::displayInput($attName.'Confirm','datetime','','confirmation',$valeur,$options,$index);
				break;
			case 'heure' : 
				$strRet .= static::displayInput($attName,'time','',$libelle,$valeur,$options,$index);
				if ( $attribut->confirm ) $strRet .= '<br />'.static::displayInput($attName.'Confirm','time','','confirmation',$valeur,$options,$index);
				break;
			case 'file' : 
				$chaine = '';
				$typeMime = $attribut->mime;
				$type = substr($typeMime,0,strpos($typeMime,'/'));
				$src = $entity->titre;
				if ( ! $entity->isFileEmpty ) {
					$chaine .= (string)$entity;
					$chaine .= '<div class="CLEARFLOAT"></div>';
				}
				$chaine .= static::displayInput($entity::$COL_ID,'hidden','','',$entity->id,'',$index);
				$chaine .= static::displayInput($entity::$COL_NOMFIC,'hidden','','',$entity->{$entity::$COL_NOMFIC},'',$index);
				$chaine .= static::displayInput($attName,'hidden','','','_'.$idName,'',$index);
				$chaine .= static::displayInput('_'.$idName,'file','',$libelle,'',$options);
				$chaine .= '';
				$strRet .= $chaine;
				break;
			case 'texte' : 
				$strRet .= static::displayTextArea($attName,$valeur,$index);
				break;
			case 'relation' : 
				$strRet .= $attribut->displayForm();
				break;
			case 'liste' : 
				$strRet .= static::displayCheckbox($attName,$attribut->object,$valeur);
				break;
		}
		$classe = "";
		if ( $attribut->nullable ) $classe = 'class="required"';
		echo '<SPAN '. $classe.'>'.$strRet .'</SPAN>'; 
	}
	
	public static function displayInput($attName,$type,$class,$libelle,$valeur,$options,$index=null) {
		$idName = $attName;
		if ( $index != null ) {
			$idName = $attName.'_'.$index;
			$attName .= '[]';
		}
		$inputMask = '<input type="#TYPE#" #CLASS# id="#IDNAME#" name="#ATTNAME#" placeholder="#LIBELLE#" value="#VALUE#"#OPTIONS#>';
		$inputMask = str_replace('#TYPE#', $type, $inputMask);
		$inputMask = str_replace('#CLASS#', $class, $inputMask);
		$inputMask = str_replace("#IDNAME#", $idName, $inputMask);
		$inputMask = str_replace("#ATTNAME#", $attName, $inputMask);
		$inputMask = str_replace('#LIBELLE#', $libelle, $inputMask); 
		$inputMask = str_replace('#VALUE#', $valeur, $inputMask);
		$inputMask = str_replace('#OPTIONS#', $options, $inputMask);
		return $inputMask;
	}
	
	public static function displaySelect($attName,$obj,$valeur,$index=null) {
		$idName = $attName;
		if ( $index != null ) {
			$idName = $attName.'_'.$index;
			$attName .= '[]';
		}
		$lstObj = $obj::selectList();
		$lstOptions = "";
		foreach ( $lstObj as $entity ) 
		{
			$selected = ( $entity->id == $valeur->value->id)? " SELECTED" : "";
			$lstOptions .= '<OPTION value="'.$entity->id.'"'.$selected.'>'.$entity.'</OPTION>';
		}
		$selectMask = '<SELECT id="'.$idName.'" name="'.$attName.'">'.$lstOptions.'</SELECT>';
		return $selectMask;
	}
	
	public static function displayTextArea($attName,$valeur,$index=null) {
		$idName = $attName;
		if ( $index != null ) {
			$idName = $attName.'_'.$index;
			$attName .= '[]';
		}
		$textMask = sprintf ('<TEXTAREA id="%s" name="%s">%s</TEXTAREA>',$idName,$attName,$valeur);
		return $textMask;
	}
	
	public static function displayRadio($attName,$lstOptions,$valeur) {
		$lstBottons = "";
		foreach ( $lstOptions as $option => $libelle) {
			$checked = ( $option == $valeur) ? 'CHECKED' : '';
			$lstBottons .= '<input type="radio" class="'.$attName.'" name="'.$attName.'" value="'.$option.'" '.$checked.'> '.$libelle.' <br />';
		}
		$radioMask = '<DIV class="lstChoix">'.$lstBottons.'</DIV>';
		return $radioMask;
	}
	
	public static function displayCheckbox($attName,$obj,$valeurs) {
		$lstObj = $obj::selectList();
		$lstBottons = "";
		foreach ( $lstObj as $entity ) {
			$checked = ( isset($valeurs[$entity->id]))? ' CHECKED' : '';
			$lstBottons .= '<input type="checkbox" class="'.$attName.'" name="'.$attName.'[]" value="'.$entity->id.'"'.$checked.'> '.$entity.' <br />';
		}
		$checkboxMask = '<DIV class="lstChoix">'.$lstBottons.'</DIV>';
		return $checkboxMask;
	}
	
	public static function displayImg($attName,$valeur,$width="",$height="") {
		$width  = ( !empty($width) )  ? "width=\"$width\"px"   : "";
		$height = ( !empty($height) ) ? "height=\"$height\"px" : "";
		$imgMask = sprintf ('<IMG src="%s" alt="%s" title="%s" %s %s /><br />',$valeur,$attName,$attName,$width,$height);
		return $imgMask;
	}
	
	public static function displayLien($attName,$valeur) {
		$imgMask = sprintf ('<A href="%s" title="%s">%s</A><br />',$valeur,$attName,$attName);
		return $imgMask;
	}
	
	/**
	* Méthode statique d'affichage d'un bouton.
	*
	* @param string $attName Nom de l'attribut
	* @param array $attribut Caractéristiques descriptives de l'attribut (tels que décrits par l'Entité)
	* @param string $valeur (default="") valeur par defaut de l'attribut
	*/
	public static function displayBouton($type,$libelle,$controller=null,$action=null,$display=null,$params=null,$title=null,$idcible=null,$pos=null,$obj=null,$idinput=null) {
		if ( $type != 'bouton' && $type != 'ajaxOpen' && $type != 'ajaxSubmit' ) 
		{
			return '<li class="'.$type.'" title="'.$title.'">'.$libelle.'</li>';
		}
		else 
		{

			$classObj = 'controllers\\'.$controller.'Controller';
			if ( isset($classObj::$SECURITY[$action]) ) 
			{
				$security = $classObj::$SECURITY[$action];
				if ( ! Security::isHabilit($security,$obj) )  return "";
			}

			$class = $type.' '.$display;
			$url = '_'.$controller.'_'.$action;
			if ( !empty($params) ) $url .= '&'.$params;
			$datas = '';
			if ( !empty($idcible) ) $datas .= ' data-idcible="'.$idcible.'" ';
			if ( !empty($idinput) ) $datas .= ' data-idinput="'.$idinput.'" ';
			if ( !empty($pos) )     $datas .= ' data-pos="'.$pos.'" ';
			if ( !empty($title) )   $datas .= ' data-titre="'.$title.'" ';
			return '<LI class="'.$class.'" data-url="'.$url.'" title="'.$title.'" '.$datas.' >'.$libelle.'</LI> ';
		}
	}
	
	/**
	* Méthode statique d'affichage d'un bouton.
	*
	* @param string $attName Nom de l'attribut
	* @param $type : type de bouton (bouton, ajaxOpen, ajaxSubmit, ajaxAdd, ajaxSearch, submit, cancel, return, close, switchEdit, drop, reset, up)
	* @param $libelle
	* @param $titre
	* @param array $attributs Caractéristiques descriptives de l'attribut (tels que décrits par l'Entité)
	* $controller=null,$action=null,$display=null,$params=null,$idcible=null,$pos=null,$obj=null,$idinput=null
	* @param string $valeur (default="") valeur par defaut de l'attribut
	*/
	public static function displayBtn($type,$libelle,$titre,$attributs=array()) 
	{
		$strParams = "";
		$url = ( isset($attributs['url']) ) ? $attributs['url'] : null;
		$display = ( isset($attributs['display']) ) ? $attributs['display'] : null;
		$params = ( isset($attributs['params']) ) ? $attributs['params'] : array();
		foreach ( $params as $key => $param ) {
			$strParam .= "data-$key=\"$param\" ";
		}
		return '<li class="'.$type.'" title="'.$titre.'" '.$strParams.'>'.$libelle.'</li>';
	}
	
}

?>