<?php
namespace lib;

class DBConnexion extends \PDO
{

	private $statement;
	
	public function __construct()
	{
		$tabVals = parse_ini_file('config/params.ini');	// Charge le fichier de param�trage 
		$this->hostname = $tabVals['dbServer'];			// Nom du serveur h�bergeant la BD
		$this->database = $tabVals['dbName'];			// Nom de la base de donn�e
		$this->username = $tabVals['dbUser'];			// Nom de connexion de l'utilisateur
		$this->password = $tabVals['dbPassword'];		// Mot de passe de l'utilisater
		parent::__construct('mysql:host='.$this->hostname.';dbname='.$this->database, $this->username, $this->password);
		$this->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
		$this->query('SET NAMES utf8');
		$this->statement = null;
	}
	
	public function getConnectErrorNumber()
	{
		return null;
	}
	
	public function getConnectError()
	{
		return null;
	}
	
	public function getError()
	{
		return $this->errorCode();
	}
	
	public function getAffectedRows()
	{
		return $this->statement->rowCount();
	}
	
	public function getInsertedId()
	{
		return $this->lastInsertId();
	}
	
	public function transaction($bool)
	{
		if ( $bool && !$this->inTransaction() ) $this->beginTransaction();
	}
	
	public function select($requete)
	{
		$this->statement = $this->prepare($requete);
		$this->statement->execute();
		$lst = array();
		while ( $ligne = $this->statement->fetch(\PDO::FETCH_ASSOC) ) $lst[] = $ligne;
		return $lst;
	}
	
	public function update($requete)
	{
		$this->statement = $this->prepare($requete);
		$this->statement->execute();
		return $this->statement->rowCount();
	}
	
	public function valider()
	{
		if ( $this->inTransaction() ) $this->commit();
	}
	
	public function annuler()
	{
		if ( $this->inTransaction() ) $this->rollback();
	}
	
	public function fermer()
	{
		null;
	}
	
	/**
	 * SQLEncode
	 * Méthode encodage pour enregistrer dans la base.
	 * @param $value : Chaine de caractères.
	 * @return string : Chaine de caractère encodée.
	 */
	public static function SQLEncode($value)
	{
		$ret = addslashes($value);
		return $ret;
	}
	
	/**
	 * SQLDecode
	 * Méthode de decodage pour les éléments dans la base.
	 * @param $value : Chaine de caractères.
	 * @return string : Chaine de caractère décodée.
	 */
	public static function SQLDecode($value)
	{
		return stripslashes($value);
	}
}