<?php
require_once "lib/autoloader.php";

use lib\DBConnexion;
use lib\Exception;
use lib\GoPrevException;
use lib\GoNextException;
use lib\GoCnxException;
use lib\CurrErrorException;
use lib\ConfirmMsgException;
use lib\Navigation;

session_start();
setlocale (LC_TIME, 'fr_FR.utf8','fra'); 

$dbcnx = null;
$redirect = false;

$controller = null;
$ret = null;
$isAjaxCall = false;
$layout = "views/layout.php";
$Model['titre_page']    = "GARI : Gestion des randonnées en ligne";
$Model['corps_page']    = "views/accueil.php";

try {
	$dbcnx = new DBConnexion();
	$model  = "Security";
	$action = "connect";
	if ( isset($_GET['model']) )  $model  = $_GET['model'];
	if ( isset($_GET['action']) ) $action = $_GET['action'];
	$classeController = "controllers\\".$model."Controller";
	if ( ! class_exists ( $classeController ) ) throw new Exception("Ce controlleur n'est pas définie : $classeController");
	
	$controller = new $classeController();
	$params = null;
	$ret = $controller->callAction($action,$params);

	if ( is_string($ret) ) 
	{
		echo $ret;
		$dbcnx->fermer();
		exit;
	}
	$Model  = $ret[1];	
	$layout = $ret[0];
	if ( $layout == null ) $layout = $Model['corps_page'];
	if ( isset($ret[2]) ) $isAjaxCall = $ret[2];
}
catch (\PDOException $e) {
//	ERREUR DE CONNEXION 0 LA BASE DE DONNEE
	$dbcnx->annuler();
	$redirect = true;
	Navigation::callCurrUrl(Exception::getMsg('ERR-DBCNX',array('ERRORCODE' => $e->getMessage())));
}
catch (CurrErrorException $e) {
//	ERREUR COURANT
	echo "<br/>".$e->getMessage()."<br/>";
	exit;
}
catch (GoCnxException $e) {
//	RETOURNE SUR LA PAGE PRECEDENTE
	$redirect = true;
	Navigation::callCnxUrl($e->getMessage());
}
catch (GoPrevException $e) {
//	RETOURNE SUR LA PAGE PRECEDENTE
	$redirect = true;
	Navigation::callPrevUrl($e->getMessage());
}
catch (GoNextException $e) {
//	RETOURNE SUR LA PAGE SUIVANTE
	$redirect = true;
	Navigation::callNextUrl($e->getMessage());
}
catch (ConfirmMsgException $e) {
//	RETOURNE SUR UN MESSAGE D'ALERTE AVEC DEMANDE DE CONFIRMATION
	$redirect = true;
	Navigation::callNextUrl($e->getMessage(),$e->getType());
}
catch (\Exception $e) {
	//	RETOURNE SUR LA PAGE COURANTE
	$redirect = true;
	Navigation::callCurrUrl($e->getMessage());
}
finally {
	$dbcnx->fermer();
}

if ( $redirect ) exit;
Navigation::putCurrUrl($isAjaxCall);
include_once $layout;
?>