<?php
namespace entities;

use lib\Entity;
use lib\attributs\Chaine;
use lib\attributs\Relation;

class TypeRando extends Entity
{
	public static $COL_ID         = 'id';
	public static $COL_CODE       = 'code';
	public static $COL_LIBELLE    = 'libelle';
	public static $COL_TYPECERTIF = 'id_typecertificat';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_CODE       => new Chaine(static::$COL_CODE),
			static::$COL_LIBELLE    => new Chaine(static::$COL_LIBELLE),
			static::$COL_TYPECERTIF => new Relation(static::$COL_TYPECERTIF,null,'entities\\TypeCertificat',null,true),
		);	
	}
	
    public function __toString()
    {
    	$libelle = static::$COL_LIBELLE;
		return $this->$libelle;
    }

	public function __get($name)
	{
		switch ( $name )
    	{
    		case 'typecertif' :
    			return $this->attributs[static::$COL_TYPECERTIF]->value;
    			break;
    		default:
    			return parent::__get($name);
    			break;
    	}
	}

	public static function displayList($init=0,$obligatoire=false)
	{
		$lst = static::selectList();
		$str  = '<SELECT name="id_typerando">';
		if ( !$obligatoire ) $str .= '	<option value="">Sélectionnez un type de randonnée ...</option>';
		foreach ( $lst as $type ) {
			$selected = "";
			if ( $init == $type->id ) $selected = "SELECTED";
			$str .= '	<option value="'.$type->id.'" '.$selected.'>'.$type->libelle.'</option>';
		}
		$str .= '</SELECT>';
		return $str;
	}
	
}

?>
