<?php
namespace entities;

use lib\Entity;
use lib\attributs\Chaine;
use lib\attributs\Texte;

class TypeCertificat extends Entity
{
	public static $COL_ID          = 'id';
	public static $COL_LIBELLE     = 'libelle';
	public static $COL_DESCRIPTION = 'description';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_LIBELLE     => new Chaine(static::$COL_LIBELLE),
			static::$COL_DESCRIPTION => new Texte(static::$COL_DESCRIPTION,null,true),
		);
	}
	
    public function __toString()
    {
		$libelle = static::$COL_LIBELLE;
        return (string)$this->$libelle;
    }

	public static function displayList($init=0,$obligatoire=false)
	{
		$lst = static::selectList();
		$str  = '<SELECT name="id_typecertificat[]">';
		if ( !$obligatoire ) $str .= '	<option value="">Sélectionnez un type de certificat ...</option>';
		foreach ( $lst as $tcertif ) {
			$selected = "";
			if ( $init == $tcertif->id ) $selected = "SELECTED";
			$str .= '	<option value="'.$tcertif->id.'" '.$selected.'>'.$tcertif->libelle.'</option>';
		}
		$str .= '</SELECT>';
		return $str;
	}
	
	public function displayForm()
	{
		return static::displayFormStat($this);
	}
	
	public static function displayFormStat($typeCertif,$certif=null)
	{
		$str = "";
		$str .= '<DIV>';
		$str .= '    <LABEL>';
		$str .= '        '.$typeCertif; 
		$str .= '        &nbsp; <input type="checkbox" name="id_typecertificat[]" value="'.$typeCertif->id.'" '. (!empty($certif)) ? "CHECKED" : "" .' />';
		$str .= '    </LABEL>';
		$str .= '    <SPAN>';
		$str .= '        <input type="text" class="date" style="width:100px;" id="dateCertificat_'.$typeCertif->id.'" name="dateCertificat_'.$typeCertif->id .'" placeholder="JJ/MM/YYYY" value="'.  ( !empty($certif) ) ? $certif->dateCertificat : "" .'" />';
		$str .= '        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Valide pour la competition <input type="checkbox" class="choix" id="validecompetition_'.$typeCertif->id.'" name="validecompetition_'.$typeCertif->id.'" value="1" '. ( !empty($certif) && $certif->validecompetition == 1 ) ? "CHECKED" : ""  .' />'; 
		$str .= '    </SPAN>';
		$str .= '</DIV>';
		return $str;
	}

}

?>
