<?php
namespace entities;

use lib\EntityRelation;
use entities\Role;

class Role_Membre extends EntityRelation
{
	public static $COL_ID             = 'id_membre';
	public static $COL_ID_REL         = 'id_role';
	protected static $NAME_ENTITY_REL = 'entities\\Role';
	
    public function __toString()
    {
		$role = static::$COL_ID_REL;
        return (string)$this->$role;
    }

	public static function displayListForm($inits=null)
	{
		$lst = Role::selectList();
		$str  = '';
		foreach ( $lst as $role ) {
			$checked = "";
			if ( $inits != null ) {
				foreach ( $inits as $init ) 
					if ( $init->id == $role->id ) $checked = "CHECKED";
			}
			if ( $role->id == 1 ) {
				$checked  = "CHECKED";
				$readonly = "READONLY";
			}
			$str .= '	<DIV><input type="checkbox" name="id_role[]" value="'.$role->id.'" '.$checked.' '.$readonly.' /> '.$role->libelle.' </DIV>';
		}
		return $str;
	}

}

?>
