<?php
namespace entities;

use lib\security\Security;
use lib\Entity;
use lib\attributs\DateHeure;
use lib\attributs\Entier;
use lib\attributs\Chaine;
use lib\attributs\Relation;
use lib\attributs\Choix;
use lib\attributs\Liste;

class Reconnaissance extends Entity
{
	public static $COL_ID                = 'id';
	public static $COL_DATERECO          = 'datereco';
	public static $COL_CARTE             = 'id_carte';
	public static $COL_LIEUDEPART        = 'lieudepart';
	public static $COL_VEHICULE          = 'vehicule';
	public static $COL_VEHICULEFORMATION = 'vehiculeFormation';
//	public static $COL_APARTIR           = 'apartir';
	public static $COL_ETAT              = 'etat';
	public static $COL_DATECREATION      = 'datecreation';
	public static $COL_CREATEUR          = 'id_createur';
	public static $COL_RESPONSABLE       = 'id_responsable';
	public static $COL_PROGRAMME         = 'id_programme';
	public static $COL_PARCOURS          = 'parcours';
	public static $COL_PARTICIPANTS      = 'participants';
	public static $COL_SYNTHESE          = 'syntheses';
	public static $COL_FICHIERS          = 'fichiers';

	public static $LVL_TRACES = array( 
		'list'           => false, 
		'display'        => false, 
		'insert'         => true, 
		'update'         => true, 
		'delete'         => true, 
		'valide'         => true, 
		'cancel'         => true, 
		'synthese'       => true, 
		'frais'          => true, 
		);
	public static $FIC_TRACES = 'data/traces/ReconnaissanceQuery.trc';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_DATERECO          => new DateHeure(static::$COL_DATERECO,null,false,false,true),
			static::$COL_CARTE             => new Relation(static::$COL_CARTE, null, 'entities\\Reco_Fichier',null,true),
			static::$COL_LIEUDEPART        => new Chaine(static::$COL_LIEUDEPART,'SANARY/MER'),
			static::$COL_VEHICULE          => new Entier(static::$COL_VEHICULE,1),
			static::$COL_VEHICULEFORMATION => new Entier(static::$COL_VEHICULEFORMATION,0),
//			static::$COL_APARTIR           => new Entier(static::$COL_APARTIR,0),
			static::$COL_ETAT              => new Choix(static::$COL_ETAT,0,array( 0 => 'Non valide', 1 => 'Valide')),
			static::$COL_DATECREATION      => new DateHeure(static::$COL_DATECREATION,date("Y-m-d H:i:s"),false,false,true),
			static::$COL_CREATEUR          => new Relation(static::$COL_CREATEUR, null, 'entities\\Membre'),
			static::$COL_RESPONSABLE       => new Relation(static::$COL_RESPONSABLE, null, 'entities\\Membre'),
			static::$COL_PROGRAMME         => new Relation(static::$COL_PROGRAMME, null, 'entities\\Programme'),
			static::$COL_PARCOURS          => new Liste(static::$COL_PARCOURS, null, 'entities\\Reco_Parcour','id_reconnaissance','id_parcour','difficulte'),
			static::$COL_PARTICIPANTS      => new Liste(static::$COL_PARTICIPANTS, null, 'entities\\Reco_Participant','id_reconnaissance','id_participant','nom,prenom'),
			static::$COL_SYNTHESE          => new Liste(static::$COL_SYNTHESE, null, 'entities\\Reco_Synthese','id_reconnaissance','remarques','datecreation'),
			static::$COL_FICHIERS          => new Liste(static::$COL_FICHIERS, null, 'entities\\Reco_Fichier','id_reconnaissance','id_fichier','dateupload'),
		);	
	}
	
    public function __toString()
    {
		return (string)$this->programme->randonnee." le ".$this->getAttribut(static::$COL_DATERECO)->date.' ('.(string)$this->id_responsable.')';
    }

	public function __get($name)
	{
		switch ( $name )
    	{
    		case 'carte' :
    			return $this->attributs[static::$COL_CARTE]->value;
    			break;
			case 'createur' :
    			return $this->attributs[static::$COL_CREATEUR]->value;
    			break;
    		case 'responsable' :
    			return $this->attributs[static::$COL_RESPONSABLE]->value;
    			break;
    		case 'programme' :
    			return $this->attributs[static::$COL_PROGRAMME]->value;
    			break;
    		case 'synthese' :
				$lst = $this->syntheses;
				if ( empty($lst) ) return null;
    			else return current($lst);
    			break;
    		default:
    			return parent::__get($name);
    			break;
    	}
	}

	public function isResponsable()
	{
		$idUser = Security::getConnectedUser()->id;
		if ( $this->id_responsable->id == $idUser ) return true;
		return false;
	}
	
	public function isProprio() {
		return $this->isResponsable();
	}

	public function afficheParcours($hasBotton=false)
	{
		$cpt = 1;
		foreach ( $this->parcours as $par ) {
			$Model['entityRel'] = $par->id_parcour;
			$Model['entity']    = $this;
			$Model['pos']       = $cpt++;
			$Model['boutons']   = $hasBotton;
			$Model['parent']    = 'reconnaissance';
			include "views/parcour/displayCell.php";
		}
	}

	public function afficheParticipants($hasBotton=false)
	{
		$cpt = 1;
		foreach ( $this->participants as $participant ) {
			$Model['entityRel'] = $participant;
			$Model['pos'] = $cpt++;
			$Model['boutons']   = $hasBotton;
			include "views/reco_participant/displayCell.php";
		}
	}
	
}

?>
