<?php
namespace entities;

use lib\EntityFichier;
use lib\attributs\Relation;

class Reco_Fichier extends EntityFichier
{
	public static $NAME_ENTITY = 'Randonnee';
	public static $COL_RECO    = 'id_reconnaissance';
	
	public function initAttributs() 
	{
		parent::initAttributs();
		$this->attributs[static::$COL_RECO] = new Relation(static::$COL_RECO,null,'entities\\Randonnee') ;
	}

	public function __get($name)
	{
		switch ( $name )
		{
			case 'reconnaissance' :
				return $this->attributs[static::$COL_RECO]->value;
				break;
			default:
				return parent::__get($name);
				break;
		}
	}

	public function initNomFichier()
	{
		return 'REC_' . uniqid() . '.fic';
	}

	public function initRepFichier()
	{
		return 'reconnaissances' ;
	}
	
}

?>
