<?php
namespace entities;

use lib\EntityFichier;
use lib\attributs\Relation;
use lib\DisplayEntity;

class Programme_Fichier extends EntityFichier
{
	public static $NAME_CTRLEUR     = 'FichierProgramme';
	public static $COL_ID           = 'id_fichier';
	public static $COL_PROGRAMME    = 'id_programme';

	protected static $TYPES = array( 
			'doc' => true, 'docx' => true, 'xls' => true, 'xlsx' => true, 'pdf' => true, 
			'gif' => true, 'png' => true, 'jpg' => true, 'jpeg' => true, 
			'trk' => true, 'gpx' => true, 'csv' => true, 'grm' => true, 'mif' => true, 'dxf' => true, 'txt' => true,  
		);

	public function __toString()
	{
		$aff = '';
		$name = $this->name;
		if ( ! empty($name) )
		{
			switch ( $this->group ) {
				case 'image' :
					$aff = '<IMG src="' . $this->url . '" alt="' . $this->name . '" />';
					break;
				default :
					$aff = '' ;
					break;
			}
			$display  = '<LABEL>' . $this->name . ' : </LABEL>';
			$display .= '<SPAN>' . $this->description . $aff . '</SPAN>';
			$display .= '<UL class="BtnsIco">';
			$display .= DisplayEntity::displayBouton('bouton','',static::$NAME_CTRLEUR,'download','download',$this->idClause,"Click pour télécharger",null,null,$this);
			$display .= DisplayEntity::displayBouton('bouton','',static::$NAME_CTRLEUR,'dropFichier','drop',$this->idClause,"Supprimer le fichier",null,null,$this);
			$display .= '</UL>';
			$aff = '<DIV class="fichierRando table">'.$display.'</DIV>';
		}
		return $aff;
	}
		
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_PROGRAMME => new Relation(static::$COL_PROGRAMME,null,'entities\\Programme')
		);	
	}

	protected function addGetter($name)
	{
		switch ( $name )
		{
			case 'programme' :
				return $this->attributs[static::$COL_PROGRAMME]->value;
				break;
		}
		return false;
	}
		
	public function initNomFichier()
	{
		return 'PROG_' . uniqid() . '.fic';
	}

	public function initRepFichier()
	{
		return 'programmes' ;
	}
	
	public function isProprio() {
		if ( $this->{static::$COL_PROGRAMME}->synthese->valide == 1 ) return false;
		return $this->{static::$COL_PROGRAMME}->isProprio();
	}
	
}

?>
