<?php
namespace entities;

use lib\Entity;
use lib\DBConnexion;
use lib\Exception;
use lib\security\Security;
use lib\attributs\Entier;
use lib\attributs\Choix;
use lib\attributs\Chaine;
use lib\attributs\Texte;
use lib\attributs\DateHeure;
use lib\attributs\Relation;
use lib\attributs\Liste;
use entities\Participant_Parcour;

class Participant extends Entity
{
	public static $COL_PROPRIO      = 'id_programme';
	public static $COL_ID           = 'id_participant';
	public static $COL_PAYE         = 'paye';
	public static $COL_ATTENTE      = 'attente';
	public static $COL_PLACES       = 'places';
	public static $COL_VENTILE      = 'ventile';
	public static $COL_DESCRIPTION  = 'description';
	public static $COL_DATECREATION = 'datecreation';
	public static $COL_PROGRAMME    = 'id_programme';
	public static $COL_MEMBRE       = 'id_membre';
	public static $COL_PERSONNE     = 'id_personne';
	public static $COL_PARCOURS     = 'parcours';
	
	public static $LVL_TRACES       = array( 'select' => false, 'insert' => false, 'update' => false, 'updatePwd' => false, 'delete' => true );
	public static $FIC_TRACES       = 'data/traces/ParticipantsQuery.trc';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_PAYE         => new Choix(static::$COL_PAYE,0,array( 0 => 'Non', 1 => 'Oui')),
			static::$COL_ATTENTE      => new Choix(static::$COL_ATTENTE,0,array( 0 => 'Non', 1 => 'Oui')),
			static::$COL_PLACES       => new Entier(static::$COL_PLACES,1),
			static::$COL_VENTILE      => new Entier(static::$COL_VENTILE,null,true),
			static::$COL_DESCRIPTION  => new Texte(static::$COL_DESCRIPTION,null,true),
			static::$COL_DATECREATION => new DateHeure(static::$COL_DATECREATION,date("Y-m-d H:i:s")),
			static::$COL_PROGRAMME    => new Relation(static::$COL_PROGRAMME, null, 'entities\\Programme'),
			static::$COL_MEMBRE       => new Relation(static::$COL_MEMBRE, null, 'entities\\Membre',null,true),
			static::$COL_PERSONNE     => new Relation(static::$COL_PERSONNE, null, 'entities\\Personne',null,true),
			static::$COL_PARCOURS     => new Liste(static::$COL_PARCOURS, null, 'entities\\Participant_Parcour','id_participant','id_parcour','difficulte'),
		);	
	}
	
    public function __toString()
    {
    	if ( $this->id_membre != null ) return (string)$this->id_membre;
    	elseif ( $this->id_personne != null ) return (string)$this->id_personne;
		else return false;
    }

	public function __get($name)
	{
		switch ( $name )
    	{
    		case 'membre' :
				if ( $this->attributs[static::$COL_MEMBRE]->value != null ) return $this->attributs[static::$COL_MEMBRE]->value;
				if ( $this->attributs[static::$COL_PERSONNE]->value != null ) return $this->attributs[static::$COL_PERSONNE]->value;
    			return 'Erreur';
    			break;
    		case 'programme' :
    			return $this->attributs[static::$COL_PROGRAMME]->value;
    			break;
    		default:
    			return parent::__get($name);
    			break;
    	}
	}
	
	public function displayMembre() 
	{
		$pers = null;
		if ( $this->attributs[static::$COL_MEMBRE]->value != null ) {
			$pers = $this->attributs[static::$COL_MEMBRE]->value;
		}
		if ( $this->attributs[static::$COL_PERSONNE]->value != null ) {
			$pers = $this->attributs[static::$COL_PERSONNE]->value;
		}
		if ( empty($pers) ) return false;
		else return $pers->nom.' '.$pers->prenom.' ('.$pers->getAttribut('datenaissance')->date.')';
	}
	
	/**
	 * insert : Surcharge de la méthode parent
	 * Insertion d'un enregistrement dans la BD
	 * @param $isTransaction=false : booleen indique si l'insertion fait partie d'une Transaction/
	 * @throws Exception
	 */
	public function insert($isTransaction=false) 
	{
		parent::insert($isTransaction);
		$programme = $this->attributs[static::$COL_PROGRAMME]->value;
		if ( count( $programme->parcours ) == 1 ) 
		{	
			$parcours = current($programme->parcours);
			$affectParcours = new Participant_Parcour();
			$affectParcours->id_participant = $this->id;
			$affectParcours->id_parcour = $parcours->id;
			$affectParcours->insert(true);
		}
		
	}
	
	/**
	 * @param string $filtres
	 * @param string $ordre
	 * @param string $limite
	 * @throws Exception
	 * @return multitype:unknown 
	 */
	public static function selectList($filtres=null,$ordre=null,$groupBy=null,$limite=null)
	{
		global $dbcnx;
		$cnx = &$dbcnx;
		$tabVals = parse_ini_file('config/params.ini');	// Charge le fichier de parametrage pour recuperer l'extension des tables 
		$classeName    = get_called_class();
		$tableName     = static::getStaticNomTable();
		$table2A       = $tabVals['dbextension'] . 'membre';
		$table2B       = $tabVals['dbextension'] . 'personne';
		$colId2A       = Membre::$COL_ID;
		$colId2B       = Personne::$COL_ID;
		$tabRet = array();
		$errmsg = " Select liste (Table ".$tableName.") : ";
		
		$query     = "";
		if ( !empty($filtres) ) {
			$query .= "SELECT ".$tableName.".*,nom,prenom FROM ".$tableName.",".$table2A." WHERE ".$tableName.".".static::$COL_MEMBRE." = ".$table2A.".".$colId2A." AND ".$filtres;
			$query .= " UNION ";
			$query .= "SELECT ".$tableName.".*,nom,prenom FROM ".$tableName.",".$table2B." WHERE ".$tableName.".".static::$COL_PERSONNE." = ".$table2B.".".$colId2B." AND ".$filtres;
		}
		if ( !empty($ordre) )   $query .= " ORDER BY ".$ordre;
		else $query .= " ORDER BY 2";
		if ( !empty($limite) )  $query .= " LIMIT ".$limite;

		$res = $cnx->select($query);
		foreach ( $res as $ligne ) {
			$obj = new $classeName( $ligne[static::$COL_ID] );
			$obj->aSupprimer();
			$tabRet[$ligne[static::$COL_ID]] = $obj;
		}
		return $tabRet;
	}
	
	public function isProprio() {
		$colproprio = static::$COL_PROPRIO;
		$programme = $this->$colproprio;
		$idUser = Security::getConnectedUser()->id;
		if ( $programme->id_responsable->id == $idUser ) return true;
		foreach ( $programme->animateurs as $animateur ) {
			if ( $animateur->id_animateur->id == $idUser ) return true;
		}
		return false;
	}

}

?>
