<?php
namespace entities;

use lib\Entity;
use lib\attributs\DateHeure;
use lib\attributs\Chaine;
use lib\attributs\Texte;
use lib\attributs\Decimal;
use lib\attributs\Entier;
use lib\attributs\Relation;
use lib\attributs\Liste;

class Parcour extends Entity
{
	public static $COL_ID           = 'id';
	public static $COL_NOM          = 'nomParcour';
	public static $COL_LONGUEUR     = 'longueur';
	public static $COL_DINIVELEUP   = 'deniveleup';
	public static $COL_DINIVELEDOWN = 'deniveledown';
	public static $COL_DIFFICULTE   = 'difficulte';
	public static $COL_IGN          = 'ign';
	public static $COL_DUREE        = 'duree';
	public static $COL_REMARQUE     = 'remarques';
	public static $COL_RANDONNEE    = 'id_randonnee';
	public static $COL_FICHIERS     = 'fichiers';
	public static $COL_PROGRAMS     = 'programmes';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_NOM          => new Chaine(static::$COL_NOM),
			static::$COL_LONGUEUR     => new Decimal(static::$COL_LONGUEUR),
			static::$COL_DINIVELEUP   => new Decimal(static::$COL_DINIVELEUP,null,true),
			static::$COL_DINIVELEDOWN => new Decimal(static::$COL_DINIVELEDOWN,null,true),
			static::$COL_DIFFICULTE   => new Entier(static::$COL_DIFFICULTE,1),
			static::$COL_IGN          => new Chaine(static::$COL_IGN,null,true),
			static::$COL_DUREE        => new DateHeure(static::$COL_DUREE,null, false,false, true),
			static::$COL_REMARQUE     => new Texte(static::$COL_REMARQUE,null,true),
			static::$COL_RANDONNEE    => new Relation(static::$COL_RANDONNEE, null, 'entities\\Randonnee'),
			static::$COL_FICHIERS     => new Liste(static::$COL_FICHIERS, null, 'entities\\Parcour_Fichier','id_parcour','id_fichier'),
			static::$COL_PROGRAMS     => new Liste(static::$COL_PROGRAMS, null, 'entities\\Programme_Parcour','id_parcour','id_programme','datedepart'),
		);	
	}
	
    public function __toString()
    {
		$parcour = $this;
        ob_start();
        include "views/parcour/displayLight.php";
        return ob_get_clean();
    }

	public function __get($name)
	{

		switch ( $name )
    	{
    		case 'randonnee' :
    			return $this->attributs[static::$COL_RANDONNEE]->value;
    			break;
     		case 'code' :
				if ( count($this->fichiers) > 0 ) {
					$lst = $this->fichiers;
					$fichier = current($lst);
					return substr($fichier->name,3,stripos($fichier->name,'.')-3);
				}
    			return uniqid();
    			break;
			case 'trace' :
				foreach ( $this->getAttribut(static::$COL_FICHIERS)->value as $fichier ) {
					if ( substr($fichier->name,0,2) == 'TR' ) return $fichier;
				}
    			return null;
    			break;
    		case 'profil' :
				foreach ( $this->getAttribut(static::$COL_FICHIERS)->value as $fichier ) {
					if ( substr($fichier->name,0,2) == 'PR' ) return $fichier;
				}
    			return null;
    			break;
    		case 'nbPrograms' :
				$lstPrograms = $this->getAttribut(static::$COL_PROGRAMS)->value;
				return count($lstPrograms);
    			break;
    		default:
    			return parent::__get($name);
    			break;
    	}
	}

	public function displayOptions() {
		ob_start();
		$id = $this->id;
		include "views/parcour/displayOptionsLight.php";
		return ob_get_clean();
	}
	
	public static function displayList($pos=null,$init=0,$obligatoire=false)
	{
		$lst = static::selectList();
		if ( $pos != null ) $pos = '_'.$pos;
		else $pos = '';
		$str  = '<SELECT name="id_parcour'.$pos.'">';
		if ( !$obligatoire ) $str .= '	<option value="">Sélectionnez un parcour ...</option>';
		foreach ( $lst as $parcour ) {
			$selected = "";
			if ( $init == $parcour->id ) $selected = "SELECTED";
			$str .= '	<option value="'.$parcour->id.'" '.$selected.'>'.$parcour->nomParcour.'</option>';
		}
		$str .= '</SELECT>';
		return $str;
	}
	
	public function displayDifficulte() {
		$str = "";
		for ( $cpt=0; $cpt<5;$cpt++) 
		{
			$chaussure = 'chaussure';
			if ( $cpt >= $this->difficulte ) $chaussure = 'chaussureG';
			$str .= '<IMG src="web/images/'.$chaussure.'.png" style="width: 9px; margin:0 1px; padding:0;" />';
		}
		return $str;
	}
	
	public function displayFichiers($bouton=true)
	{
		$pos = 0;
		foreach ( $this->fichiers as $fichier ) {
			$pos++;
			$Model['entity']  = $fichier;
			$Model['pos']     = $pos;
			$Model['boutons'] = true;
			$Model['edit']    = $bouton;
			include "views/fichier/update.php";
		}
	}
	
}

?>
