<?php
namespace entities;

use lib\Entity;
use lib\attributs\DateHeure;
use lib\attributs\Entier;
use lib\attributs\Chaine;
use lib\attributs\Texte;
use lib\attributs\Relation;

class Information extends Entity
{

	public static $COL_ID           = 'id';
	public static $COL_MOIS_ANNEE   = 'mois_annee';
	public static $COL_POSITION     = 'position';
	public static $COL_TITRE        = 'titre';
	public static $COL_INFORMATION  = 'txtinformation';
	public static $COL_ID_TYPERANDO = 'id_typerando';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_MOIS_ANNEE   => new DateHeure(static::$COL_MOIS_ANNEE,null,false,false),
			static::$COL_POSITION     => new Entier(static::$COL_POSITION,1),
			static::$COL_TITRE        => new Chaine(static::$COL_TITRE),
			static::$COL_INFORMATION  => new Texte(static::$COL_INFORMATION),
			static::$COL_ID_TYPERANDO => new Relation(static::$COL_ID_TYPERANDO, null, 'entities\\TypeRando'),
		);	
	}
	
    public function __toString()
    {
    	$titre = static::$COL_TITRE;
    	$info  = static::$COL_INFORMATION;
		return '<H3>'.$this->$titre.'</H3><P>'.$this->$info.'</P>';
    }

	public function __get($name)
	{
		switch ( $name )
    	{
    		case 'typerando' :
    			return $this->attributs[static::$COL_ID_TYPERANDO]->value;
    			break;
    		default:
    			return parent::__get($name);
    			break;
    	}
	}
	
}

?>
