<?php
namespace entities;

use lib\Entity;
use lib\attributs\Chaine;
use lib\attributs\Texte;
use lib\attributs\DateHeure;
use lib\attributs\Decimal;
use lib\attributs\Relation;

class Cheque extends Entity
{
	public static $COL_ID            = 'id_cheque';
	public static $COL_NOM           = 'nomCheque';
	public static $COL_DATEEMISSION  = 'dateCheque';
	public static $COL_MONTANT       = 'montantCheque';
	public static $COL_NUMERO        = 'numeroCheque';
	public static $COL_ETABLISSEMENT = 'etablissementCheque';
	public static $COL_NOTE          = 'noteCheque';
	public static $COL_MEMBRE        = 'id_membre';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_NOM           => new Chaine(static::$COL_NOM),
			static::$COL_DATEEMISSION  => new DateHeure(static::$COL_DATEEMISSION,date("Y-m-d H:i:s")),
			static::$COL_MONTANT       => new Decimal(static::$COL_MONTANT,0.00),
			static::$COL_NUMERO        => new Chaine(static::$COL_NUMERO,null,true),
			static::$COL_ETABLISSEMENT => new Chaine(static::$COL_ETABLISSEMENT,null,true),
			static::$COL_NOTE          => new Texte(static::$COL_NOTE,'Paiement cotisation d\'inscription',true),
			static::$COL_MEMBRE        => new Relation(static::$COL_MEMBRE, null, 'entities\\Membre'),		
		);
	}
	
    public function __toString()
    {
		$nom = static::$COL_NOM;
		$note = static::$COL_NOTE;
		$etablissement = static::$COL_ETABLISSEMENT;
		$montant = static::$COL_MONTANT;
		$noteStr = "";
		if ( $this->$note != null ) $noteStr = '('.$this->$note.')';
        return $this->$nom.' : '.$this->$montant.' Euro '.$noteStr;
    }

}

?>
