<?php
namespace entities;

use lib\EntityRelation;
use lib\attributs\Chaine;
use lib\attributs\Texte;
use lib\attributs\DateHeure;
use lib\attributs\Choix;
use lib\attributs\Relation;

class Certificat_Membre extends EntityRelation
{
	public static $COL_DATECERTIF  = 'dateCertificat';
	public static $COL_DATEATTEST1 = 'dateAttestation1';
	public static $COL_DATEATTEST2 = 'dateAttestation2';
	public static $COL_VALIDCOMPET = 'validecompetition';
	public static $COL_TYPECERTIF  = 'id_typecertificat';

	public static $COL_ID          = 'id_membre';
	protected static $NAME_ENTITY  = 'entities\\Membre';
	public static $COL_ID_REL      = 'id_typecertificat';
	protected static $NAME_ENTITY_REL = 'entities\\TypeCertificat';
	
	public function initAttributs() 
	{
		parent::initAttributs();
		$this->attributs[static::$COL_DATECERTIF]  = new DateHeure(static::$COL_DATECERTIF,date("Y-m-d H:i:s"));
		$this->attributs[static::$COL_DATEATTEST1] = new DateHeure(static::$COL_DATEATTEST1, null, true);
		$this->attributs[static::$COL_DATEATTEST2] = new DateHeure(static::$COL_DATEATTEST2, null, true);
		$this->attributs[static::$COL_VALIDCOMPET] = new Choix(static::$COL_VALIDCOMPET,0,array( 0 => 'Non', 1 => 'Oui'));
	}
	
    public function __toString()
    {
		$type   = static::$COL_TYPECERTIF;
		$date   = $this->getAttribut(static::$COL_DATECERTIF)->date;
		$date1   = $this->getAttribut(static::$COL_DATEATTEST1)->date;
		$date2   = $this->getAttribut(static::$COL_DATEATTEST2)->date;
		if ( !empty($date2) ) $date = $date2;
		elseif ( !empty($date1) ) $date = $date1;
		$compet = static::$COL_VALIDCOMPET;
		$ok = "";
		if ( $this->$compet == 1 ) $ok = "*";
        return (string)$this->$type . $ok . ' ('.$date.')';
    }

	public function __get($name)
	{
		switch ( $name )
    	{
    		case 'typecertif' :
    			return $this->attributs[static::$COL_TYPECERTIF]->value;
    			break;
    		default:
    			return parent::__get($name);
    			break;
    	}
	}
	
	public function valide($certificat)
	{
		$certif = $this->typecertif;
		if ( $certif->id == $certificat->id ) {
			if ( $ret = $this->getAttribut(static::$COL_DATECERTIF)->higherThanToday('P1Y') ) 
				return true;
			elseif ( $this->getAttribut(static::$COL_DATECERTIF)->higherThanToday('P2Y') && $this->getAttribut(static::$COL_DATEATTEST1)->higherThanToday('P1Y') ) 
				return true;
			elseif ( $this->getAttribut(static::$COL_DATECERTIF)->higherThanToday('P3Y') && $this->getAttribut(static::$COL_DATEATTEST2)->higherThanToday('P1Y') ) 
				return true;
		}
		return false;
	}
	
	public function displayForm()
	{
		$str = "";
		$str .= '<input type="hidden" name="id_typecertificat[]" value="'. ( !empty($certif) ) ? $certif->dateCertificat : "" .'" />';
		$str .= '    <LABEL>';
		$str .= '        '.$typeCertif; 
		$str .= '        &nbsp; <input type="checkbox" name="id_typecertificat[]" value="'.$typeCertif->id.'" '. (!empty($certif)) ? "CHECKED" : "" .' />';
		$str .= '    </LABEL>';
		$str .= '    <SPAN>';
		$str .= '<input type="hidden" name="dateCertificat_'.$typeCertif->id .'" placeholder="JJ/MM/YYYY" value="'. ( !empty($certif) ) ? $certif->dateCertificat : "" .'" />';
		$str .= '        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Valide pour la competition <input type="checkbox" class="choix" id="validecompetition_'.$typeCertif->id.'" name="validecompetition_'.$typeCertif->id.'" value="1" '. ( !empty($certif) && $certif->validecompetition == 1 ) ? "CHECKED" : ""  .' />'; 
		$str .= '    </SPAN>';
		$str .= '</DIV>';
		return $str;
	}

}

?>
