<?php
namespace entities;

use lib\Entity;
use lib\attributs\Chaine;
use lib\attributs\DateHeure;
use lib\attributs\Relation;

class CAmembre extends Entity
{
	public static $COL_ID           = 'id';
	public static $COL_DATECA       = 'dateca';
	public static $COL_DATESORTIECA = 'datesortieca';
	public static $COL_POSTECA      = 'posteCA';
	public static $COL_MEMBRE       = 'id_membre';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_DATECA       => new DateHeure(static::$COL_DATECA,date("Y-m-d H:i:s"), false, false, true),
			static::$COL_DATESORTIECA => new DateHeure(static::$COL_DATESORTIECA,date("Y-m-d H:i:s"), false, false, true),
			static::$COL_POSTECA      => new Chaine(static::$COL_POSTECA,null,true),
			static::$COL_MEMBRE       => new Relation(static::$COL_MEMBRE, null, 'entities\\Membre'),		
		);
	}
	
    public function __toString()
    {
		$date = static::$COL_DATECA;
        return $this->$date;
    }

}

?>
