<?php
namespace entities;

use lib\Entity;
use lib\attributs\Chaine;
use lib\attributs\DateHeure;
use lib\attributs\Relation;

class Brevet extends Entity
{
	public static $COL_ID            = 'id_brevet';
	public static $COL_DATEOBTENTION = 'dateBrevet';
	public static $COL_NUMERO        = 'numeroBrevet';
	public static $NOTE              = 'noteBrevet';
	public static $COL_TYPEBREVET    = 'id_typebrevet';
	public static $COL_MEMBRE        = 'id_membre';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_DATEOBTENTION => new DateHeure(static::$COL_DATEOBTENTION, date("Y-m-d H:i:s"), false,false, true),
			static::$COL_NUMERO        => new Chaine(static::$COL_NUMERO,null,true),
			static::$NOTE              => new Chaine(static::$NOTE,null,true),
			static::$COL_TYPEBREVET    => new Relation(static::$COL_TYPEBREVET, null, 'entities\\TypeBrevet',null,true),
			static::$COL_MEMBRE        => new Relation(static::$COL_MEMBRE, null, 'entities\\Membre',null,true),
		);
	}
	
    public function __toString()
    {
		$typebrevet = static::$COL_TYPEBREVET;
		$datebrevet = static::$COL_DATEOBTENTION;
        return (string)$this->$typebrevet.' ('.$this->getAttribut($datebrevet)->date.')';
    }

}

?>
