<?php
namespace entities;

use lib\Entity;
use lib\attributs\Chaine;
use lib\attributs\Relation;

class Adresse extends Entity
{
	public static $COL_ID         = 'id_adresse';
	public static $COL_LIBELLE    = 'libelleAdresse';
	public static $COL_ADRESSE    = 'adresse';
	public static $COL_COMPLEMENT = 'complement';
	public static $COL_CP         = 'cp';
	public static $COL_COMMUNE    = 'commune';
	public static $COL_MEMBRE     = 'id_membre';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_LIBELLE    => new Chaine(static::$COL_LIBELLE),
			static::$COL_ADRESSE    => new Chaine(static::$COL_ADRESSE),
			static::$COL_COMPLEMENT => new Chaine(static::$COL_COMPLEMENT,null,true),
			static::$COL_CP         => new Chaine(static::$COL_CP,null,true),
			static::$COL_COMMUNE    => new Chaine(static::$COL_COMMUNE,null,true),
			static::$COL_MEMBRE     => new Relation(static::$COL_MEMBRE, null, 'entities\\Membre',null,true),		
		);
	}
	
    public function __toString()
    {
		$libelle = static::$COL_LIBELLE;
		$adresse = static::$COL_ADRESSE;
		$cp = static::$COL_CP;
		$commune = static::$COL_COMMUNE;
        return '<b>'.$this->$libelle.'</b> : '.$this->$adresse.', '.$this->$cp.' '.$this->$commune;
    }
	
    public function getAddr()
    {
		$adresse = static::$COL_ADRESSE;
		$cp = static::$COL_CP;
		$commune = static::$COL_COMMUNE;
        return $this->$adresse.', '.$this->$cp.' '.$this->$commune;
    }

}

?>
