<?php
namespace controllers;

use lib\EntityController;
use lib\Exception;
use lib\Constantes;
use lib\attributs\DateHeure;
use entities\Participant;

class StatistiqueController extends EntityController
{
	public static $SECURITY = array(
		'generale'      => array(2,3,4,5,6),
		'statUser'      => array(0,6),
		'statGenerales' => array(2,3,4,5,6),
		);
	protected static $ENTITY = "entities\Membre";
	
	public function statAnnuellesAction($params=null)
	{
		if ( empty($_GET['annee']) ) throw new Exception('ERR-FORM-OBLIGAT ',array( 'ATTRIBNAME' => 'annee' ));
		$Model['titre_page']    = "Statistiques annuelles";
		$Model['corps_page']    = "views/statistique/statAnnuelles.php";
		$Model['annee']         = $_GET['annee'];
		return array("views/layout.php",$Model);
	}
	
	public function statGeneralesAction($params=null)
	{
		
		$dateMax = new \DateTime();
		$year = intval((new \DateTime())->format('Y'));
		if ( intval((new \DateTime())->format('m')) <= 9 ) $year--;
		$dateMin = new \DateTime("$year-09-01");
		
		if ( !empty($_POST['dateMin']) ) $dateMin = new \DateTime(DateHeure::strToDate($_POST['dateMin']));
		if ( !empty($_POST['dateMax']) ) $dateMax = new \DateTime(DateHeure::strToDate($_POST['dateMax']));

		$lst = null;
		
		$Model['titre_page']        = "Statistiques générales";
		$Model['corps_page']        = "views/statistique/statGenerales.php";
		$Model['lstentities']       = $lst;
		$Model['dateMin']    = $dateMin;
		$Model['dateMax']    = $dateMax;
		return array("views/layout.php",$Model);
	}
	
	public function statUserAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-PARAM-NOID');
		$membre = $params['entity'];
		
		$dateMax = new \DateTime();
		$year = intval((new \DateTime())->format('Y'));
		if ( intval((new \DateTime())->format('m')) <= 9 ) $year--;
		$dateMin = new \DateTime("$year-09-01");
		
		if ( !empty($_POST['dateMin']) ) $dateMin = new \DateTime(DateHeure::strToDate($_POST['dateMin']));
		if ( !empty($_POST['dateMax']) ) $dateMax = new \DateTime(DateHeure::strToDate($_POST['dateMax']));
		
		global $dbcnx;
		
		$QR ="
			SELECT 
				PA.id_participant ID, 
				PAR.longueur LONGUEUR, 
				PAR.deniveleup UP, 
				PAR.deniveledown DOWN 
			FROM gari_participant as PA 
			inner join gari_participant_parcour as PPAR on PPAR.id_participant = PA.id_participant
			inner join gari_programme as PRO on PRO.id = PA.id_programme
			inner join gari_parcour as PAR on PAR.id = PPAR.id_parcour
			WHERE 
				PA.id_membre = ".$membre->id."
				AND PRO.datedepart BETWEEN '".$dateMin->format('Y-m-d')."' and '".$dateMax->format('Y-m-d')."' 
			ORDER BY PRO.datedepart;
		";
		
		$select = $dbcnx->select($QR);
		$lst = array();
		$distanceTotale = 0;
		$deniveleUpTotal = 0;
		$deniveleDownTotal = 0;
		foreach ($select as $ligne) {
			$distanceTotale    += $ligne['LONGUEUR'];
			$deniveleUpTotal   += $ligne['UP'];
			$deniveleDownTotal += $ligne['DOWN'];
			$lst[] = new Participant($ligne['ID']);
		}
		
		$Model['titre_page'] = "Statistiques Utilisateur : ".(string)$membre;
		$Model['corps_page'] = "views/statistique/statUser.php";
		$Model['lstentities']       = $lst;
		$Model['distanceTotale']    = $distanceTotale;
		$Model['deniveleUpTotal']   = $deniveleUpTotal;
		$Model['deniveleDownTotal'] = $deniveleDownTotal;
		$Model['dateMin']    = $dateMin;
		$Model['dateMax']    = $dateMax;
		$Model['idMembre']   = $membre->id;
		return array("views/layout.php",$Model);
	}

}
